<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ItemBreakdown StructType
 * @subpackage Structs
 */
class JP_ItemBreakdown extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The Quantity
     * @var int
     */
    public $Quantity;
    /**
     * The Days
     * @var int
     */
    public $Days;
    /**
     * The PaxType
     * @var string
     */
    public $PaxType;
    /**
     * The TtaCode
     * @var int
     */
    public $TtaCode;
    /**
     * The SupplierAmount
     * @var float
     */
    public $SupplierAmount;
    /**
     * The SupplierCurrency
     * @var string
     */
    public $SupplierCurrency;
    /**
     * The Source
     * @var string
     */
    public $Source;
    /**
     * Constructor method for JP_ItemBreakdown
     * @uses JP_ItemBreakdown::setAmount()
     * @uses JP_ItemBreakdown::setDate()
     * @uses JP_ItemBreakdown::setQuantity()
     * @uses JP_ItemBreakdown::setDays()
     * @uses JP_ItemBreakdown::setPaxType()
     * @uses JP_ItemBreakdown::setTtaCode()
     * @uses JP_ItemBreakdown::setSupplierAmount()
     * @uses JP_ItemBreakdown::setSupplierCurrency()
     * @uses JP_ItemBreakdown::setSource()
     * @param float $amount
     * @param string $date
     * @param int $quantity
     * @param int $days
     * @param string $paxType
     * @param int $ttaCode
     * @param float $supplierAmount
     * @param string $supplierCurrency
     * @param string $source
     */
    public function __construct($amount = null, $date = null, $quantity = null, $days = null, $paxType = null, $ttaCode = null, $supplierAmount = null, $supplierCurrency = null, $source = null)
    {
        $this
            ->setAmount($amount)
            ->setDate($date)
            ->setQuantity($quantity)
            ->setDays($days)
            ->setPaxType($paxType)
            ->setTtaCode($ttaCode)
            ->setSupplierAmount($supplierAmount)
            ->setSupplierCurrency($supplierCurrency)
            ->setSource($source);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\JP_ItemBreakdown
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\JP_ItemBreakdown
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Quantity value
     * @return int|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param int $quantity
     * @return \StructType\JP_ItemBreakdown
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Days value
     * @return int|null
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param int $days
     * @return \StructType\JP_ItemBreakdown
     */
    public function setDays($days = null)
    {
        // validation for constraint: int
        if (!is_null($days) && !(is_int($days) || ctype_digit($days))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($days, true), gettype($days)), __LINE__);
        }
        $this->Days = $days;
        return $this;
    }
    /**
     * Get PaxType value
     * @return string|null
     */
    public function getPaxType()
    {
        return $this->PaxType;
    }
    /**
     * Set PaxType value
     * @param string $paxType
     * @return \StructType\JP_ItemBreakdown
     */
    public function setPaxType($paxType = null)
    {
        // validation for constraint: string
        if (!is_null($paxType) && !is_string($paxType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxType, true), gettype($paxType)), __LINE__);
        }
        $this->PaxType = $paxType;
        return $this;
    }
    /**
     * Get TtaCode value
     * @return int|null
     */
    public function getTtaCode()
    {
        return $this->TtaCode;
    }
    /**
     * Set TtaCode value
     * @param int $ttaCode
     * @return \StructType\JP_ItemBreakdown
     */
    public function setTtaCode($ttaCode = null)
    {
        // validation for constraint: int
        if (!is_null($ttaCode) && !(is_int($ttaCode) || ctype_digit($ttaCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ttaCode, true), gettype($ttaCode)), __LINE__);
        }
        $this->TtaCode = $ttaCode;
        return $this;
    }
    /**
     * Get SupplierAmount value
     * @return float|null
     */
    public function getSupplierAmount()
    {
        return $this->SupplierAmount;
    }
    /**
     * Set SupplierAmount value
     * @param float $supplierAmount
     * @return \StructType\JP_ItemBreakdown
     */
    public function setSupplierAmount($supplierAmount = null)
    {
        // validation for constraint: float
        if (!is_null($supplierAmount) && !(is_float($supplierAmount) || is_numeric($supplierAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($supplierAmount, true), gettype($supplierAmount)), __LINE__);
        }
        $this->SupplierAmount = $supplierAmount;
        return $this;
    }
    /**
     * Get SupplierCurrency value
     * @return string|null
     */
    public function getSupplierCurrency()
    {
        return $this->SupplierCurrency;
    }
    /**
     * Set SupplierCurrency value
     * @param string $supplierCurrency
     * @return \StructType\JP_ItemBreakdown
     */
    public function setSupplierCurrency($supplierCurrency = null)
    {
        // validation for constraint: string
        if (!is_null($supplierCurrency) && !is_string($supplierCurrency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierCurrency, true), gettype($supplierCurrency)), __LINE__);
        }
        $this->SupplierCurrency = $supplierCurrency;
        return $this;
    }
    /**
     * Get Source value
     * @return string|null
     */
    public function getSource()
    {
        return $this->Source;
    }
    /**
     * Set Source value
     * @param string $source
     * @return \StructType\JP_ItemBreakdown
     */
    public function setSource($source = null)
    {
        // validation for constraint: string
        if (!is_null($source) && !is_string($source)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($source, true), gettype($source)), __LINE__);
        }
        $this->Source = $source;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ItemBreakdown
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
