<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelResult StructType
 * @subpackage Structs
 */
class JP_HotelResult extends AbstractStructBase
{
    /**
     * The HotelInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelInfo
     */
    public $HotelInfo;
    /**
     * The HotelOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_HotelOption
     */
    public $HotelOptions;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The JPCode
     * @var string
     */
    public $JPCode;
    /**
     * The OriginZone
     * @var string
     */
    public $OriginZone;
    /**
     * The JPDCode
     * @var string
     */
    public $JPDCode;
    /**
     * The ResultType
     * @var string
     */
    public $ResultType;
    /**
     * The SubType
     * @var string
     */
    public $SubType;
    /**
     * The BestDeal
     * @var bool
     */
    public $BestDeal;
    /**
     * The DestinationZone
     * @var string
     */
    public $DestinationZone;
    /**
     * Constructor method for JP_HotelResult
     * @uses JP_HotelResult::setHotelInfo()
     * @uses JP_HotelResult::setHotelOptions()
     * @uses JP_HotelResult::setCode()
     * @uses JP_HotelResult::setJPCode()
     * @uses JP_HotelResult::setOriginZone()
     * @uses JP_HotelResult::setJPDCode()
     * @uses JP_HotelResult::setResultType()
     * @uses JP_HotelResult::setSubType()
     * @uses JP_HotelResult::setBestDeal()
     * @uses JP_HotelResult::setDestinationZone()
     * @param \StructType\JP_HotelInfo $hotelInfo
     * @param \ArrayType\ArrayOfJP_HotelOption $hotelOptions
     * @param string $code
     * @param string $jPCode
     * @param string $originZone
     * @param string $jPDCode
     * @param string $resultType
     * @param string $subType
     * @param bool $bestDeal
     * @param string $destinationZone
     */
    public function __construct(\StructType\JP_HotelInfo $hotelInfo = null, \ArrayType\ArrayOfJP_HotelOption $hotelOptions = null, $code = null, $jPCode = null, $originZone = null, $jPDCode = null, $resultType = null, $subType = null, $bestDeal = null, $destinationZone = null)
    {
        $this
            ->setHotelInfo($hotelInfo)
            ->setHotelOptions($hotelOptions)
            ->setCode($code)
            ->setJPCode($jPCode)
            ->setOriginZone($originZone)
            ->setJPDCode($jPDCode)
            ->setResultType($resultType)
            ->setSubType($subType)
            ->setBestDeal($bestDeal)
            ->setDestinationZone($destinationZone);
    }
    /**
     * Get HotelInfo value
     * @return \StructType\JP_HotelInfo|null
     */
    public function getHotelInfo()
    {
        return $this->HotelInfo;
    }
    /**
     * Set HotelInfo value
     * @param \StructType\JP_HotelInfo $hotelInfo
     * @return \StructType\JP_HotelResult
     */
    public function setHotelInfo(\StructType\JP_HotelInfo $hotelInfo = null)
    {
        $this->HotelInfo = $hotelInfo;
        return $this;
    }
    /**
     * Get HotelOptions value
     * @return \ArrayType\ArrayOfJP_HotelOption|null
     */
    public function getHotelOptions()
    {
        return $this->HotelOptions;
    }
    /**
     * Set HotelOptions value
     * @param \ArrayType\ArrayOfJP_HotelOption $hotelOptions
     * @return \StructType\JP_HotelResult
     */
    public function setHotelOptions(\ArrayType\ArrayOfJP_HotelOption $hotelOptions = null)
    {
        $this->HotelOptions = $hotelOptions;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_HotelResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get JPCode value
     * @return string|null
     */
    public function getJPCode()
    {
        return $this->JPCode;
    }
    /**
     * Set JPCode value
     * @param string $jPCode
     * @return \StructType\JP_HotelResult
     */
    public function setJPCode($jPCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPCode) && !is_string($jPCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jPCode, true), gettype($jPCode)), __LINE__);
        }
        $this->JPCode = $jPCode;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return string|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param string $originZone
     * @return \StructType\JP_HotelResult
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: string
        if (!is_null($originZone) && !is_string($originZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originZone, true), gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get JPDCode value
     * @return string|null
     */
    public function getJPDCode()
    {
        return $this->JPDCode;
    }
    /**
     * Set JPDCode value
     * @param string $jPDCode
     * @return \StructType\JP_HotelResult
     */
    public function setJPDCode($jPDCode = null)
    {
        // validation for constraint: string
        if (!is_null($jPDCode) && !is_string($jPDCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($jPDCode, true), gettype($jPDCode)), __LINE__);
        }
        $this->JPDCode = $jPDCode;
        return $this;
    }
    /**
     * Get ResultType value
     * @return string|null
     */
    public function getResultType()
    {
        return $this->ResultType;
    }
    /**
     * Set ResultType value
     * @param string $resultType
     * @return \StructType\JP_HotelResult
     */
    public function setResultType($resultType = null)
    {
        // validation for constraint: string
        if (!is_null($resultType) && !is_string($resultType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultType, true), gettype($resultType)), __LINE__);
        }
        $this->ResultType = $resultType;
        return $this;
    }
    /**
     * Get SubType value
     * @return string|null
     */
    public function getSubType()
    {
        return $this->SubType;
    }
    /**
     * Set SubType value
     * @param string $subType
     * @return \StructType\JP_HotelResult
     */
    public function setSubType($subType = null)
    {
        // validation for constraint: string
        if (!is_null($subType) && !is_string($subType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subType, true), gettype($subType)), __LINE__);
        }
        $this->SubType = $subType;
        return $this;
    }
    /**
     * Get BestDeal value
     * @return bool|null
     */
    public function getBestDeal()
    {
        return $this->BestDeal;
    }
    /**
     * Set BestDeal value
     * @param bool $bestDeal
     * @return \StructType\JP_HotelResult
     */
    public function setBestDeal($bestDeal = null)
    {
        // validation for constraint: boolean
        if (!is_null($bestDeal) && !is_bool($bestDeal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bestDeal, true), gettype($bestDeal)), __LINE__);
        }
        $this->BestDeal = $bestDeal;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return string|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param string $destinationZone
     * @return \StructType\JP_HotelResult
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: string
        if (!is_null($destinationZone) && !is_string($destinationZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
