<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelRatesRS StructType
 * @subpackage Structs
 */
class JP_HotelRatesRS extends AbstractStructBase
{
    /**
     * The Contract
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_HotelRatePlanContract[]
     */
    public $Contract;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCodeEncrypt
     * @var string
     */
    public $HotelCodeEncrypt;
    /**
     * Constructor method for JP_HotelRatesRS
     * @uses JP_HotelRatesRS::setContract()
     * @uses JP_HotelRatesRS::setHotelCode()
     * @uses JP_HotelRatesRS::setHotelCodeEncrypt()
     * @param \StructType\JPSOAP_HotelRatePlanContract[] $contract
     * @param string $hotelCode
     * @param string $hotelCodeEncrypt
     */
    public function __construct(array $contract = array(), $hotelCode = null, $hotelCodeEncrypt = null)
    {
        $this
            ->setContract($contract)
            ->setHotelCode($hotelCode)
            ->setHotelCodeEncrypt($hotelCodeEncrypt);
    }
    /**
     * Get Contract value
     * @return \StructType\JPSOAP_HotelRatePlanContract[]|null
     */
    public function getContract()
    {
        return $this->Contract;
    }
    /**
     * This method is responsible for validating the values passed to the setContract method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContract method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContractForArrayConstraintsFromSetContract(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_HotelRatesRSContractItem) {
            // validation for constraint: itemType
            if (!$jP_HotelRatesRSContractItem instanceof \StructType\JPSOAP_HotelRatePlanContract) {
                $invalidValues[] = is_object($jP_HotelRatesRSContractItem) ? get_class($jP_HotelRatesRSContractItem) : sprintf('%s(%s)', gettype($jP_HotelRatesRSContractItem), var_export($jP_HotelRatesRSContractItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Contract property can only contain items of type \StructType\JPSOAP_HotelRatePlanContract, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_HotelRatePlanContract[] $contract
     * @return \StructType\JP_HotelRatesRS
     */
    public function setContract(array $contract = array())
    {
        // validation for constraint: array
        if ('' !== ($contractArrayErrorMessage = self::validateContractForArrayConstraintsFromSetContract($contract))) {
            throw new \InvalidArgumentException($contractArrayErrorMessage, __LINE__);
        }
        $this->Contract = $contract;
        return $this;
    }
    /**
     * Add item to Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_HotelRatePlanContract $item
     * @return \StructType\JP_HotelRatesRS
     */
    public function addToContract(\StructType\JPSOAP_HotelRatePlanContract $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_HotelRatePlanContract) {
            throw new \InvalidArgumentException(sprintf('The Contract property can only contain items of type \StructType\JPSOAP_HotelRatePlanContract, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Contract[] = $item;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\JP_HotelRatesRS
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCode, true), gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCodeEncrypt value
     * @return string|null
     */
    public function getHotelCodeEncrypt()
    {
        return $this->HotelCodeEncrypt;
    }
    /**
     * Set HotelCodeEncrypt value
     * @param string $hotelCodeEncrypt
     * @return \StructType\JP_HotelRatesRS
     */
    public function setHotelCodeEncrypt($hotelCodeEncrypt = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeEncrypt) && !is_string($hotelCodeEncrypt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hotelCodeEncrypt, true), gettype($hotelCodeEncrypt)), __LINE__);
        }
        $this->HotelCodeEncrypt = $hotelCodeEncrypt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelRatesRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
