<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelConfirmModify StructType
 * @subpackage Structs
 */
class JP_HotelConfirmModify extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The ReservationLocator
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ReservationLocationModify
     */
    public $ReservationLocator;
    /**
     * The Paxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Paxes
     */
    public $Paxes;
    /**
     * The Holder
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Holder
     */
    public $Holder;
    /**
     * The ExternalBookingReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExternalBookingReference;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * The HotelElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelConfirmElement
     */
    public $HotelElement;
    /**
     * The AdvancedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_HotelModifyAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The RestrictedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for JP_HotelConfirmModify
     * @uses JP_HotelConfirmModify::setLogin()
     * @uses JP_HotelConfirmModify::setReservationLocator()
     * @uses JP_HotelConfirmModify::setPaxes()
     * @uses JP_HotelConfirmModify::setHolder()
     * @uses JP_HotelConfirmModify::setExternalBookingReference()
     * @uses JP_HotelConfirmModify::setComments()
     * @uses JP_HotelConfirmModify::setHotelElement()
     * @uses JP_HotelConfirmModify::setAdvancedOptions()
     * @uses JP_HotelConfirmModify::setRestrictedOptions()
     * @uses JP_HotelConfirmModify::setVersion()
     * @uses JP_HotelConfirmModify::setLanguage()
     * @uses JP_HotelConfirmModify::setTimeStamp()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_ReservationLocationModify $reservationLocator
     * @param \StructType\JP_Paxes $paxes
     * @param \StructType\JP_Holder $holder
     * @param string $externalBookingReference
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @param \StructType\JP_HotelConfirmElement $hotelElement
     * @param \StructType\JP_HotelModifyAdvancedOptions $advancedOptions
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     * @param string $timeStamp
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_ReservationLocationModify $reservationLocator = null, \StructType\JP_Paxes $paxes = null, \StructType\JP_Holder $holder = null, $externalBookingReference = null, \ArrayType\ArrayOfJP_Comment $comments = null, \StructType\JP_HotelConfirmElement $hotelElement = null, \StructType\JP_HotelModifyAdvancedOptions $advancedOptions = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null, $timeStamp = null)
    {
        $this
            ->setLogin($login)
            ->setReservationLocator($reservationLocator)
            ->setPaxes($paxes)
            ->setHolder($holder)
            ->setExternalBookingReference($externalBookingReference)
            ->setComments($comments)
            ->setHotelElement($hotelElement)
            ->setAdvancedOptions($advancedOptions)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get ReservationLocator value
     * @return \StructType\JP_ReservationLocationModify|null
     */
    public function getReservationLocator()
    {
        return $this->ReservationLocator;
    }
    /**
     * Set ReservationLocator value
     * @param \StructType\JP_ReservationLocationModify $reservationLocator
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setReservationLocator(\StructType\JP_ReservationLocationModify $reservationLocator = null)
    {
        $this->ReservationLocator = $reservationLocator;
        return $this;
    }
    /**
     * Get Paxes value
     * @return \StructType\JP_Paxes|null
     */
    public function getPaxes()
    {
        return $this->Paxes;
    }
    /**
     * Set Paxes value
     * @param \StructType\JP_Paxes $paxes
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setPaxes(\StructType\JP_Paxes $paxes = null)
    {
        $this->Paxes = $paxes;
        return $this;
    }
    /**
     * Get Holder value
     * @return \StructType\JP_Holder|null
     */
    public function getHolder()
    {
        return $this->Holder;
    }
    /**
     * Set Holder value
     * @param \StructType\JP_Holder $holder
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setHolder(\StructType\JP_Holder $holder = null)
    {
        $this->Holder = $holder;
        return $this;
    }
    /**
     * Get ExternalBookingReference value
     * @return string|null
     */
    public function getExternalBookingReference()
    {
        return $this->ExternalBookingReference;
    }
    /**
     * Set ExternalBookingReference value
     * @param string $externalBookingReference
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setExternalBookingReference($externalBookingReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalBookingReference) && !is_string($externalBookingReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBookingReference, true), gettype($externalBookingReference)), __LINE__);
        }
        $this->ExternalBookingReference = $externalBookingReference;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Get HotelElement value
     * @return \StructType\JP_HotelConfirmElement|null
     */
    public function getHotelElement()
    {
        return $this->HotelElement;
    }
    /**
     * Set HotelElement value
     * @param \StructType\JP_HotelConfirmElement $hotelElement
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setHotelElement(\StructType\JP_HotelConfirmElement $hotelElement = null)
    {
        $this->HotelElement = $hotelElement;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_HotelModifyAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_HotelModifyAdvancedOptions $advancedOptions
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setAdvancedOptions(\StructType\JP_HotelModifyAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($version, true), gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($language, true), gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_HotelConfirmModify
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($timeStamp, true), gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelConfirmModify
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
