<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FareGroupPrice StructType
 * @subpackage Structs
 */
class JP_FareGroupPrice extends AbstractStructBase
{
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_Price[]
     */
    public $Price;
    /**
     * The FareGroupCode
     * @var string
     */
    public $FareGroupCode;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_FareGroupPrice
     * @uses JP_FareGroupPrice::setPrice()
     * @uses JP_FareGroupPrice::setFareGroupCode()
     * @uses JP_FareGroupPrice::setRatePlanCode()
     * @param \StructType\JP_Price[] $price
     * @param string $fareGroupCode
     * @param string $ratePlanCode
     */
    public function __construct(array $price = array(), $fareGroupCode = null, $ratePlanCode = null)
    {
        $this
            ->setPrice($price)
            ->setFareGroupCode($fareGroupCode)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Price value
     * @return \StructType\JP_Price[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_FareGroupPricePriceItem) {
            // validation for constraint: itemType
            if (!$jP_FareGroupPricePriceItem instanceof \StructType\JP_Price) {
                $invalidValues[] = is_object($jP_FareGroupPricePriceItem) ? get_class($jP_FareGroupPricePriceItem) : sprintf('%s(%s)', gettype($jP_FareGroupPricePriceItem), var_export($jP_FareGroupPricePriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Price property can only contain items of type \StructType\JP_Price, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Price[] $price
     * @return \StructType\JP_FareGroupPrice
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_Price $item
     * @return \StructType\JP_FareGroupPrice
     */
    public function addToPrice(\StructType\JP_Price $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_Price) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of type \StructType\JP_Price, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Get FareGroupCode value
     * @return string|null
     */
    public function getFareGroupCode()
    {
        return $this->FareGroupCode;
    }
    /**
     * Set FareGroupCode value
     * @param string $fareGroupCode
     * @return \StructType\JP_FareGroupPrice
     */
    public function setFareGroupCode($fareGroupCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareGroupCode) && !is_string($fareGroupCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareGroupCode, true), gettype($fareGroupCode)), __LINE__);
        }
        $this->FareGroupCode = $fareGroupCode;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_FareGroupPrice
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FareGroupPrice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
