<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Contents StructType
 * @subpackage Structs
 */
class JP_Contents extends AbstractStructBase
{
    /**
     * The HotelContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_HotelContent[]
     */
    public $HotelContent;
    /**
     * The PackageContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PackageContent[]
     */
    public $PackageContent;
    /**
     * The RentacarLocationContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_RentacarLocationDetail[]
     */
    public $RentacarLocationContent;
    /**
     * The ServiceContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ServiceContent[]
     */
    public $ServiceContent;
    /**
     * The TransferContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_TransferContent[]
     */
    public $TransferContent;
    /**
     * Constructor method for JP_Contents
     * @uses JP_Contents::setHotelContent()
     * @uses JP_Contents::setPackageContent()
     * @uses JP_Contents::setRentacarLocationContent()
     * @uses JP_Contents::setServiceContent()
     * @uses JP_Contents::setTransferContent()
     * @param \StructType\JP_HotelContent[] $hotelContent
     * @param \StructType\JP_PackageContent[] $packageContent
     * @param \StructType\JP_RentacarLocationDetail[] $rentacarLocationContent
     * @param \StructType\JP_ServiceContent[] $serviceContent
     * @param \StructType\JP_TransferContent[] $transferContent
     */
    public function __construct(array $hotelContent = array(), array $packageContent = array(), array $rentacarLocationContent = array(), array $serviceContent = array(), array $transferContent = array())
    {
        $this
            ->setHotelContent($hotelContent)
            ->setPackageContent($packageContent)
            ->setRentacarLocationContent($rentacarLocationContent)
            ->setServiceContent($serviceContent)
            ->setTransferContent($transferContent);
    }
    /**
     * Get HotelContent value
     * @return \StructType\JP_HotelContent[]|null
     */
    public function getHotelContent()
    {
        return $this->HotelContent;
    }
    /**
     * This method is responsible for validating the values passed to the setHotelContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setHotelContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateHotelContentForArrayConstraintsFromSetHotelContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ContentsHotelContentItem) {
            // validation for constraint: itemType
            if (!$jP_ContentsHotelContentItem instanceof \StructType\JP_HotelContent) {
                $invalidValues[] = is_object($jP_ContentsHotelContentItem) ? get_class($jP_ContentsHotelContentItem) : sprintf('%s(%s)', gettype($jP_ContentsHotelContentItem), var_export($jP_ContentsHotelContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The HotelContent property can only contain items of type \StructType\JP_HotelContent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set HotelContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelContent[] $hotelContent
     * @return \StructType\JP_Contents
     */
    public function setHotelContent(array $hotelContent = array())
    {
        // validation for constraint: array
        if ('' !== ($hotelContentArrayErrorMessage = self::validateHotelContentForArrayConstraintsFromSetHotelContent($hotelContent))) {
            throw new \InvalidArgumentException($hotelContentArrayErrorMessage, __LINE__);
        }
        $this->HotelContent = $hotelContent;
        return $this;
    }
    /**
     * Add item to HotelContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_HotelContent $item
     * @return \StructType\JP_Contents
     */
    public function addToHotelContent(\StructType\JP_HotelContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_HotelContent) {
            throw new \InvalidArgumentException(sprintf('The HotelContent property can only contain items of type \StructType\JP_HotelContent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->HotelContent[] = $item;
        return $this;
    }
    /**
     * Get PackageContent value
     * @return \StructType\JP_PackageContent[]|null
     */
    public function getPackageContent()
    {
        return $this->PackageContent;
    }
    /**
     * This method is responsible for validating the values passed to the setPackageContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPackageContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePackageContentForArrayConstraintsFromSetPackageContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ContentsPackageContentItem) {
            // validation for constraint: itemType
            if (!$jP_ContentsPackageContentItem instanceof \StructType\JP_PackageContent) {
                $invalidValues[] = is_object($jP_ContentsPackageContentItem) ? get_class($jP_ContentsPackageContentItem) : sprintf('%s(%s)', gettype($jP_ContentsPackageContentItem), var_export($jP_ContentsPackageContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PackageContent property can only contain items of type \StructType\JP_PackageContent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PackageContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageContent[] $packageContent
     * @return \StructType\JP_Contents
     */
    public function setPackageContent(array $packageContent = array())
    {
        // validation for constraint: array
        if ('' !== ($packageContentArrayErrorMessage = self::validatePackageContentForArrayConstraintsFromSetPackageContent($packageContent))) {
            throw new \InvalidArgumentException($packageContentArrayErrorMessage, __LINE__);
        }
        $this->PackageContent = $packageContent;
        return $this;
    }
    /**
     * Add item to PackageContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PackageContent $item
     * @return \StructType\JP_Contents
     */
    public function addToPackageContent(\StructType\JP_PackageContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PackageContent) {
            throw new \InvalidArgumentException(sprintf('The PackageContent property can only contain items of type \StructType\JP_PackageContent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PackageContent[] = $item;
        return $this;
    }
    /**
     * Get RentacarLocationContent value
     * @return \StructType\JP_RentacarLocationDetail[]|null
     */
    public function getRentacarLocationContent()
    {
        return $this->RentacarLocationContent;
    }
    /**
     * This method is responsible for validating the values passed to the setRentacarLocationContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRentacarLocationContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRentacarLocationContentForArrayConstraintsFromSetRentacarLocationContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ContentsRentacarLocationContentItem) {
            // validation for constraint: itemType
            if (!$jP_ContentsRentacarLocationContentItem instanceof \StructType\JP_RentacarLocationDetail) {
                $invalidValues[] = is_object($jP_ContentsRentacarLocationContentItem) ? get_class($jP_ContentsRentacarLocationContentItem) : sprintf('%s(%s)', gettype($jP_ContentsRentacarLocationContentItem), var_export($jP_ContentsRentacarLocationContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The RentacarLocationContent property can only contain items of type \StructType\JP_RentacarLocationDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set RentacarLocationContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RentacarLocationDetail[] $rentacarLocationContent
     * @return \StructType\JP_Contents
     */
    public function setRentacarLocationContent(array $rentacarLocationContent = array())
    {
        // validation for constraint: array
        if ('' !== ($rentacarLocationContentArrayErrorMessage = self::validateRentacarLocationContentForArrayConstraintsFromSetRentacarLocationContent($rentacarLocationContent))) {
            throw new \InvalidArgumentException($rentacarLocationContentArrayErrorMessage, __LINE__);
        }
        $this->RentacarLocationContent = $rentacarLocationContent;
        return $this;
    }
    /**
     * Add item to RentacarLocationContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_RentacarLocationDetail $item
     * @return \StructType\JP_Contents
     */
    public function addToRentacarLocationContent(\StructType\JP_RentacarLocationDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_RentacarLocationDetail) {
            throw new \InvalidArgumentException(sprintf('The RentacarLocationContent property can only contain items of type \StructType\JP_RentacarLocationDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->RentacarLocationContent[] = $item;
        return $this;
    }
    /**
     * Get ServiceContent value
     * @return \StructType\JP_ServiceContent[]|null
     */
    public function getServiceContent()
    {
        return $this->ServiceContent;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceContentForArrayConstraintsFromSetServiceContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ContentsServiceContentItem) {
            // validation for constraint: itemType
            if (!$jP_ContentsServiceContentItem instanceof \StructType\JP_ServiceContent) {
                $invalidValues[] = is_object($jP_ContentsServiceContentItem) ? get_class($jP_ContentsServiceContentItem) : sprintf('%s(%s)', gettype($jP_ContentsServiceContentItem), var_export($jP_ContentsServiceContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceContent property can only contain items of type \StructType\JP_ServiceContent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceContent[] $serviceContent
     * @return \StructType\JP_Contents
     */
    public function setServiceContent(array $serviceContent = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceContentArrayErrorMessage = self::validateServiceContentForArrayConstraintsFromSetServiceContent($serviceContent))) {
            throw new \InvalidArgumentException($serviceContentArrayErrorMessage, __LINE__);
        }
        $this->ServiceContent = $serviceContent;
        return $this;
    }
    /**
     * Add item to ServiceContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceContent $item
     * @return \StructType\JP_Contents
     */
    public function addToServiceContent(\StructType\JP_ServiceContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ServiceContent) {
            throw new \InvalidArgumentException(sprintf('The ServiceContent property can only contain items of type \StructType\JP_ServiceContent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceContent[] = $item;
        return $this;
    }
    /**
     * Get TransferContent value
     * @return \StructType\JP_TransferContent[]|null
     */
    public function getTransferContent()
    {
        return $this->TransferContent;
    }
    /**
     * This method is responsible for validating the values passed to the setTransferContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTransferContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTransferContentForArrayConstraintsFromSetTransferContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_ContentsTransferContentItem) {
            // validation for constraint: itemType
            if (!$jP_ContentsTransferContentItem instanceof \StructType\JP_TransferContent) {
                $invalidValues[] = is_object($jP_ContentsTransferContentItem) ? get_class($jP_ContentsTransferContentItem) : sprintf('%s(%s)', gettype($jP_ContentsTransferContentItem), var_export($jP_ContentsTransferContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TransferContent property can only contain items of type \StructType\JP_TransferContent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TransferContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferContent[] $transferContent
     * @return \StructType\JP_Contents
     */
    public function setTransferContent(array $transferContent = array())
    {
        // validation for constraint: array
        if ('' !== ($transferContentArrayErrorMessage = self::validateTransferContentForArrayConstraintsFromSetTransferContent($transferContent))) {
            throw new \InvalidArgumentException($transferContentArrayErrorMessage, __LINE__);
        }
        $this->TransferContent = $transferContent;
        return $this;
    }
    /**
     * Add item to TransferContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferContent $item
     * @return \StructType\JP_Contents
     */
    public function addToTransferContent(\StructType\JP_TransferContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_TransferContent) {
            throw new \InvalidArgumentException(sprintf('The TransferContent property can only contain items of type \StructType\JP_TransferContent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TransferContent[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Contents
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
