<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CancelAdvancedOptions StructType
 * @subpackage Structs
 */
class JP_CancelAdvancedOptions extends JP_BaseAdvancedOptions
{
    /**
     * The SendMailTo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SendMailTo;
    /**
     * The ShowBreakdownPrice
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $ShowBreakdownPrice;
    /**
     * Constructor method for JP_CancelAdvancedOptions
     * @uses JP_CancelAdvancedOptions::setSendMailTo()
     * @uses JP_CancelAdvancedOptions::setShowBreakdownPrice()
     * @param string $sendMailTo
     * @param bool $showBreakdownPrice
     */
    public function __construct($sendMailTo = null, $showBreakdownPrice = null)
    {
        $this
            ->setSendMailTo($sendMailTo)
            ->setShowBreakdownPrice($showBreakdownPrice);
    }
    /**
     * Get SendMailTo value
     * @return string|null
     */
    public function getSendMailTo()
    {
        return $this->SendMailTo;
    }
    /**
     * Set SendMailTo value
     * @uses \EnumType\JP_SendMailTo::valueIsValid()
     * @uses \EnumType\JP_SendMailTo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sendMailTo
     * @return \StructType\JP_CancelAdvancedOptions
     */
    public function setSendMailTo($sendMailTo = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_SendMailTo::valueIsValid($sendMailTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_SendMailTo', is_array($sendMailTo) ? implode(', ', $sendMailTo) : var_export($sendMailTo, true), implode(', ', \EnumType\JP_SendMailTo::getValidValues())), __LINE__);
        }
        $this->SendMailTo = $sendMailTo;
        return $this;
    }
    /**
     * Get ShowBreakdownPrice value
     * @return bool|null
     */
    public function getShowBreakdownPrice()
    {
        return $this->ShowBreakdownPrice;
    }
    /**
     * Set ShowBreakdownPrice value
     * @param bool $showBreakdownPrice
     * @return \StructType\JP_CancelAdvancedOptions
     */
    public function setShowBreakdownPrice($showBreakdownPrice = null)
    {
        // validation for constraint: boolean
        if (!is_null($showBreakdownPrice) && !is_bool($showBreakdownPrice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showBreakdownPrice, true), gettype($showBreakdownPrice)), __LINE__);
        }
        $this->ShowBreakdownPrice = $showBreakdownPrice;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CancelAdvancedOptions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
