<?php

namespace EnumType;

/**
 * This class stands for JP_CabinType EnumType
 * @subpackage Enumerations
 */
class JP_CabinType
{
    /**
     * Constant for value 'Undefined'
     * @return string 'Undefined'
     */
    const VALUE_UNDEFINED = 'Undefined';
    /**
     * Constant for value 'Business'
     * @return string 'Business'
     */
    const VALUE_BUSINESS = 'Business';
    /**
     * Constant for value 'First'
     * @return string 'First'
     */
    const VALUE_FIRST = 'First';
    /**
     * Constant for value 'Economy'
     * @return string 'Economy'
     */
    const VALUE_ECONOMY = 'Economy';
    /**
     * Constant for value 'Premium'
     * @return string 'Premium'
     */
    const VALUE_PREMIUM = 'Premium';
    /**
     * Constant for value 'PremiumBusiness'
     * @return string 'PremiumBusiness'
     */
    const VALUE_PREMIUM_BUSINESS = 'PremiumBusiness';
    /**
     * Constant for value 'PremiumFirst'
     * @return string 'PremiumFirst'
     */
    const VALUE_PREMIUM_FIRST = 'PremiumFirst';
    /**
     * Constant for value 'PremiumEconomy'
     * @return string 'PremiumEconomy'
     */
    const VALUE_PREMIUM_ECONOMY = 'PremiumEconomy';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_UNDEFINED
     * @uses self::VALUE_BUSINESS
     * @uses self::VALUE_FIRST
     * @uses self::VALUE_ECONOMY
     * @uses self::VALUE_PREMIUM
     * @uses self::VALUE_PREMIUM_BUSINESS
     * @uses self::VALUE_PREMIUM_FIRST
     * @uses self::VALUE_PREMIUM_ECONOMY
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_UNDEFINED,
            self::VALUE_BUSINESS,
            self::VALUE_FIRST,
            self::VALUE_ECONOMY,
            self::VALUE_PREMIUM,
            self::VALUE_PREMIUM_BUSINESS,
            self::VALUE_PREMIUM_FIRST,
            self::VALUE_PREMIUM_ECONOMY,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
