<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_GenericCatalogueItemContent ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_GenericCatalogueItemContent extends AbstractStructArrayBase
{
    /**
     * The ItemContent
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_GenericCatalogueItemContent[]
     */
    public $ItemContent;
    /**
     * Constructor method for ArrayOfJP_GenericCatalogueItemContent
     * @uses ArrayOfJP_GenericCatalogueItemContent::setItemContent()
     * @param \StructType\JP_GenericCatalogueItemContent[] $itemContent
     */
    public function __construct(array $itemContent = array())
    {
        $this
            ->setItemContent($itemContent);
    }
    /**
     * Get ItemContent value
     * @return \StructType\JP_GenericCatalogueItemContent[]|null
     */
    public function getItemContent()
    {
        return $this->ItemContent;
    }
    /**
     * This method is responsible for validating the values passed to the setItemContent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setItemContent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateItemContentForArrayConstraintsFromSetItemContent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_GenericCatalogueItemContentItemContentItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_GenericCatalogueItemContentItemContentItem instanceof \StructType\JP_GenericCatalogueItemContent) {
                $invalidValues[] = is_object($arrayOfJP_GenericCatalogueItemContentItemContentItem) ? get_class($arrayOfJP_GenericCatalogueItemContentItemContentItem) : sprintf('%s(%s)', gettype($arrayOfJP_GenericCatalogueItemContentItemContentItem), var_export($arrayOfJP_GenericCatalogueItemContentItemContentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ItemContent property can only contain items of type \StructType\JP_GenericCatalogueItemContent, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ItemContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_GenericCatalogueItemContent[] $itemContent
     * @return \ArrayType\ArrayOfJP_GenericCatalogueItemContent
     */
    public function setItemContent(array $itemContent = array())
    {
        // validation for constraint: array
        if ('' !== ($itemContentArrayErrorMessage = self::validateItemContentForArrayConstraintsFromSetItemContent($itemContent))) {
            throw new \InvalidArgumentException($itemContentArrayErrorMessage, __LINE__);
        }
        $this->ItemContent = $itemContent;
        return $this;
    }
    /**
     * Add item to ItemContent value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_GenericCatalogueItemContent $item
     * @return \ArrayType\ArrayOfJP_GenericCatalogueItemContent
     */
    public function addToItemContent(\StructType\JP_GenericCatalogueItemContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_GenericCatalogueItemContent) {
            throw new \InvalidArgumentException(sprintf('The ItemContent property can only contain items of type \StructType\JP_GenericCatalogueItemContent, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ItemContent[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_GenericCatalogueItemContent|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_GenericCatalogueItemContent|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_GenericCatalogueItemContent|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_GenericCatalogueItemContent|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_GenericCatalogueItemContent|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemContent
     */
    public function getAttributeName()
    {
        return 'ItemContent';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_GenericCatalogueItemContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
