<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_CruiseCabin ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_CruiseCabin extends AbstractStructArrayBase
{
    /**
     * The Cabin
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CruiseCabin[]
     */
    public $Cabin;
    /**
     * Constructor method for ArrayOfJP_CruiseCabin
     * @uses ArrayOfJP_CruiseCabin::setCabin()
     * @param \StructType\JP_CruiseCabin[] $cabin
     */
    public function __construct(array $cabin = array())
    {
        $this
            ->setCabin($cabin);
    }
    /**
     * Get Cabin value
     * @return \StructType\JP_CruiseCabin[]|null
     */
    public function getCabin()
    {
        return $this->Cabin;
    }
    /**
     * This method is responsible for validating the values passed to the setCabin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCabin method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCabinForArrayConstraintsFromSetCabin(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_CruiseCabinCabinItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_CruiseCabinCabinItem instanceof \StructType\JP_CruiseCabin) {
                $invalidValues[] = is_object($arrayOfJP_CruiseCabinCabinItem) ? get_class($arrayOfJP_CruiseCabinCabinItem) : sprintf('%s(%s)', gettype($arrayOfJP_CruiseCabinCabinItem), var_export($arrayOfJP_CruiseCabinCabinItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Cabin property can only contain items of type \StructType\JP_CruiseCabin, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Cabin value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseCabin[] $cabin
     * @return \ArrayType\ArrayOfJP_CruiseCabin
     */
    public function setCabin(array $cabin = array())
    {
        // validation for constraint: array
        if ('' !== ($cabinArrayErrorMessage = self::validateCabinForArrayConstraintsFromSetCabin($cabin))) {
            throw new \InvalidArgumentException($cabinArrayErrorMessage, __LINE__);
        }
        $this->Cabin = $cabin;
        return $this;
    }
    /**
     * Add item to Cabin value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseCabin $item
     * @return \ArrayType\ArrayOfJP_CruiseCabin
     */
    public function addToCabin(\StructType\JP_CruiseCabin $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CruiseCabin) {
            throw new \InvalidArgumentException(sprintf('The Cabin property can only contain items of type \StructType\JP_CruiseCabin, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Cabin[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_CruiseCabin|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_CruiseCabin|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_CruiseCabin|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_CruiseCabin|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_CruiseCabin|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Cabin
     */
    public function getAttributeName()
    {
        return 'Cabin';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_CruiseCabin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
