<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ContentProvider ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ContentProvider extends AbstractStructArrayBase
{
    /**
     * The ContentProvider
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ContentProvider[]
     */
    public $ContentProvider;
    /**
     * Constructor method for ArrayOfJP_ContentProvider
     * @uses ArrayOfJP_ContentProvider::setContentProvider()
     * @param \StructType\JP_ContentProvider[] $contentProvider
     */
    public function __construct(array $contentProvider = array())
    {
        $this
            ->setContentProvider($contentProvider);
    }
    /**
     * Get ContentProvider value
     * @return \StructType\JP_ContentProvider[]|null
     */
    public function getContentProvider()
    {
        return $this->ContentProvider;
    }
    /**
     * This method is responsible for validating the values passed to the setContentProvider method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContentProvider method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContentProviderForArrayConstraintsFromSetContentProvider(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_ContentProviderContentProviderItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ContentProviderContentProviderItem instanceof \StructType\JP_ContentProvider) {
                $invalidValues[] = is_object($arrayOfJP_ContentProviderContentProviderItem) ? get_class($arrayOfJP_ContentProviderContentProviderItem) : sprintf('%s(%s)', gettype($arrayOfJP_ContentProviderContentProviderItem), var_export($arrayOfJP_ContentProviderContentProviderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContentProvider property can only contain items of type \StructType\JP_ContentProvider, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContentProvider value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ContentProvider[] $contentProvider
     * @return \ArrayType\ArrayOfJP_ContentProvider
     */
    public function setContentProvider(array $contentProvider = array())
    {
        // validation for constraint: array
        if ('' !== ($contentProviderArrayErrorMessage = self::validateContentProviderForArrayConstraintsFromSetContentProvider($contentProvider))) {
            throw new \InvalidArgumentException($contentProviderArrayErrorMessage, __LINE__);
        }
        $this->ContentProvider = $contentProvider;
        return $this;
    }
    /**
     * Add item to ContentProvider value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ContentProvider $item
     * @return \ArrayType\ArrayOfJP_ContentProvider
     */
    public function addToContentProvider(\StructType\JP_ContentProvider $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ContentProvider) {
            throw new \InvalidArgumentException(sprintf('The ContentProvider property can only contain items of type \StructType\JP_ContentProvider, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContentProvider[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ContentProvider|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ContentProvider|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ContentProvider|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ContentProvider|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ContentProvider|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ContentProvider
     */
    public function getAttributeName()
    {
        return 'ContentProvider';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_ContentProvider
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
