<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferResult StructType
 * @subpackage Structs
 */
class JP_TransferResult extends AbstractStructBase
{
    /**
     * The Start
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Start;
    /**
     * The End
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $End;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The TransferInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferInfo
     */
    public $TransferInfo;
    /**
     * The TransferOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_TransferOption
     */
    public $TransferOptions;
    /**
     * The Prices
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Price
     */
    public $Prices;
    /**
     * The Origins
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Origin
     */
    public $Origins;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Destination
     */
    public $Destinations;
    /**
     * The OriginZone
     * @var int
     */
    public $OriginZone;
    /**
     * The DestinationZone
     * @var int
     */
    public $DestinationZone;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * Constructor method for JP_TransferResult
     * @uses JP_TransferResult::setStart()
     * @uses JP_TransferResult::setEnd()
     * @uses JP_TransferResult::setStatus()
     * @uses JP_TransferResult::setTransferInfo()
     * @uses JP_TransferResult::setTransferOptions()
     * @uses JP_TransferResult::setPrices()
     * @uses JP_TransferResult::setOrigins()
     * @uses JP_TransferResult::setDestinations()
     * @uses JP_TransferResult::setOriginZone()
     * @uses JP_TransferResult::setDestinationZone()
     * @uses JP_TransferResult::setCode()
     * @uses JP_TransferResult::setRatePlanCode()
     * @param string $start
     * @param string $end
     * @param string $status
     * @param \StructType\JP_TransferInfo $transferInfo
     * @param \ArrayType\ArrayOfJP_TransferOption $transferOptions
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @param int $originZone
     * @param int $destinationZone
     * @param string $code
     * @param string $ratePlanCode
     */
    public function __construct($start = null, $end = null, $status = null, \StructType\JP_TransferInfo $transferInfo = null, \ArrayType\ArrayOfJP_TransferOption $transferOptions = null, \ArrayType\ArrayOfJP_Price $prices = null, \ArrayType\ArrayOfJP_Origin $origins = null, \ArrayType\ArrayOfJP_Destination $destinations = null, $originZone = null, $destinationZone = null, $code = null, $ratePlanCode = null)
    {
        $this
            ->setStart($start)
            ->setEnd($end)
            ->setStatus($status)
            ->setTransferInfo($transferInfo)
            ->setTransferOptions($transferOptions)
            ->setPrices($prices)
            ->setOrigins($origins)
            ->setDestinations($destinations)
            ->setOriginZone($originZone)
            ->setDestinationZone($destinationZone)
            ->setCode($code)
            ->setRatePlanCode($ratePlanCode);
    }
    /**
     * Get Start value
     * @return string
     */
    public function getStart()
    {
        return $this->Start;
    }
    /**
     * Set Start value
     * @param string $start
     * @return \StructType\JP_TransferResult
     */
    public function setStart($start = null)
    {
        // validation for constraint: string
        if (!is_null($start) && !is_string($start)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($start, true), gettype($start)), __LINE__);
        }
        $this->Start = $start;
        return $this;
    }
    /**
     * Get End value
     * @return string
     */
    public function getEnd()
    {
        return $this->End;
    }
    /**
     * Set End value
     * @param string $end
     * @return \StructType\JP_TransferResult
     */
    public function setEnd($end = null)
    {
        // validation for constraint: string
        if (!is_null($end) && !is_string($end)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($end, true), gettype($end)), __LINE__);
        }
        $this->End = $end;
        return $this;
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_AvailStatus::valueIsValid()
     * @uses \EnumType\JP_AvailStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_TransferResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_AvailStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_AvailStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\JP_AvailStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TransferInfo value
     * @return \StructType\JP_TransferInfo|null
     */
    public function getTransferInfo()
    {
        return $this->TransferInfo;
    }
    /**
     * Set TransferInfo value
     * @param \StructType\JP_TransferInfo $transferInfo
     * @return \StructType\JP_TransferResult
     */
    public function setTransferInfo(\StructType\JP_TransferInfo $transferInfo = null)
    {
        $this->TransferInfo = $transferInfo;
        return $this;
    }
    /**
     * Get TransferOptions value
     * @return \ArrayType\ArrayOfJP_TransferOption|null
     */
    public function getTransferOptions()
    {
        return $this->TransferOptions;
    }
    /**
     * Set TransferOptions value
     * @param \ArrayType\ArrayOfJP_TransferOption $transferOptions
     * @return \StructType\JP_TransferResult
     */
    public function setTransferOptions(\ArrayType\ArrayOfJP_TransferOption $transferOptions = null)
    {
        $this->TransferOptions = $transferOptions;
        return $this;
    }
    /**
     * Get Prices value
     * @return \ArrayType\ArrayOfJP_Price|null
     */
    public function getPrices()
    {
        return $this->Prices;
    }
    /**
     * Set Prices value
     * @param \ArrayType\ArrayOfJP_Price $prices
     * @return \StructType\JP_TransferResult
     */
    public function setPrices(\ArrayType\ArrayOfJP_Price $prices = null)
    {
        $this->Prices = $prices;
        return $this;
    }
    /**
     * Get Origins value
     * @return \ArrayType\ArrayOfJP_Origin|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @return \StructType\JP_TransferResult
     */
    public function setOrigins(\ArrayType\ArrayOfJP_Origin $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \ArrayType\ArrayOfJP_Destination|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @return \StructType\JP_TransferResult
     */
    public function setDestinations(\ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return int|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param int $originZone
     * @return \StructType\JP_TransferResult
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: int
        if (!is_null($originZone) && !(is_int($originZone) || ctype_digit($originZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($originZone, true), gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_TransferResult
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !(is_int($destinationZone) || ctype_digit($destinationZone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($destinationZone, true), gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_TransferResult
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_TransferResult
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_TransferResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
