<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceContent StructType
 * @subpackage Structs
 */
class JP_ServiceContent extends AbstractStructBase
{
    /**
     * The ServiceContentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServiceContentInfo
     */
    public $ServiceContentInfo;
    /**
     * The ServiceZones
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Zone
     */
    public $ServiceZones;
    /**
     * The ServiceOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_ServiceContentOption
     */
    public $ServiceOptions;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_ServiceContent
     * @uses JP_ServiceContent::setServiceContentInfo()
     * @uses JP_ServiceContent::setServiceZones()
     * @uses JP_ServiceContent::setServiceOptions()
     * @uses JP_ServiceContent::setCode()
     * @param \StructType\JP_ServiceContentInfo $serviceContentInfo
     * @param \ArrayType\ArrayOfJP_Zone $serviceZones
     * @param \ArrayType\ArrayOfJP_ServiceContentOption $serviceOptions
     * @param string $code
     */
    public function __construct(\StructType\JP_ServiceContentInfo $serviceContentInfo = null, \ArrayType\ArrayOfJP_Zone $serviceZones = null, \ArrayType\ArrayOfJP_ServiceContentOption $serviceOptions = null, $code = null)
    {
        $this
            ->setServiceContentInfo($serviceContentInfo)
            ->setServiceZones($serviceZones)
            ->setServiceOptions($serviceOptions)
            ->setCode($code);
    }
    /**
     * Get ServiceContentInfo value
     * @return \StructType\JP_ServiceContentInfo|null
     */
    public function getServiceContentInfo()
    {
        return $this->ServiceContentInfo;
    }
    /**
     * Set ServiceContentInfo value
     * @param \StructType\JP_ServiceContentInfo $serviceContentInfo
     * @return \StructType\JP_ServiceContent
     */
    public function setServiceContentInfo(\StructType\JP_ServiceContentInfo $serviceContentInfo = null)
    {
        $this->ServiceContentInfo = $serviceContentInfo;
        return $this;
    }
    /**
     * Get ServiceZones value
     * @return \ArrayType\ArrayOfJP_Zone|null
     */
    public function getServiceZones()
    {
        return $this->ServiceZones;
    }
    /**
     * Set ServiceZones value
     * @param \ArrayType\ArrayOfJP_Zone $serviceZones
     * @return \StructType\JP_ServiceContent
     */
    public function setServiceZones(\ArrayType\ArrayOfJP_Zone $serviceZones = null)
    {
        $this->ServiceZones = $serviceZones;
        return $this;
    }
    /**
     * Get ServiceOptions value
     * @return \ArrayType\ArrayOfJP_ServiceContentOption|null
     */
    public function getServiceOptions()
    {
        return $this->ServiceOptions;
    }
    /**
     * Set ServiceOptions value
     * @param \ArrayType\ArrayOfJP_ServiceContentOption $serviceOptions
     * @return \StructType\JP_ServiceContent
     */
    public function setServiceOptions(\ArrayType\ArrayOfJP_ServiceContentOption $serviceOptions = null)
    {
        $this->ServiceOptions = $serviceOptions;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_ServiceContent
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
