<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServiceAdditionalElement StructType
 * @subpackage Structs
 */
class JP_ServiceAdditionalElement extends AbstractStructBase
{
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The RestrictedMeetingPoints
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_MeetingPoint
     */
    public $RestrictedMeetingPoints;
    /**
     * The Origins
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Origin
     */
    public $Origins;
    /**
     * The Destinations
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Destination
     */
    public $Destinations;
    /**
     * Constructor method for JP_ServiceAdditionalElement
     * @uses JP_ServiceAdditionalElement::setCode()
     * @uses JP_ServiceAdditionalElement::setName()
     * @uses JP_ServiceAdditionalElement::setRestrictedMeetingPoints()
     * @uses JP_ServiceAdditionalElement::setOrigins()
     * @uses JP_ServiceAdditionalElement::setDestinations()
     * @param int $code
     * @param string $name
     * @param \ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     */
    public function __construct($code = null, $name = null, \ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints = null, \ArrayType\ArrayOfJP_Origin $origins = null, \ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this
            ->setCode($code)
            ->setName($name)
            ->setRestrictedMeetingPoints($restrictedMeetingPoints)
            ->setOrigins($origins)
            ->setDestinations($destinations);
    }
    /**
     * Get Code value
     * @return int
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get RestrictedMeetingPoints value
     * @return \ArrayType\ArrayOfJP_MeetingPoint|null
     */
    public function getRestrictedMeetingPoints()
    {
        return $this->RestrictedMeetingPoints;
    }
    /**
     * Set RestrictedMeetingPoints value
     * @param \ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setRestrictedMeetingPoints(\ArrayType\ArrayOfJP_MeetingPoint $restrictedMeetingPoints = null)
    {
        $this->RestrictedMeetingPoints = $restrictedMeetingPoints;
        return $this;
    }
    /**
     * Get Origins value
     * @return \ArrayType\ArrayOfJP_Origin|null
     */
    public function getOrigins()
    {
        return $this->Origins;
    }
    /**
     * Set Origins value
     * @param \ArrayType\ArrayOfJP_Origin $origins
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setOrigins(\ArrayType\ArrayOfJP_Origin $origins = null)
    {
        $this->Origins = $origins;
        return $this;
    }
    /**
     * Get Destinations value
     * @return \ArrayType\ArrayOfJP_Destination|null
     */
    public function getDestinations()
    {
        return $this->Destinations;
    }
    /**
     * Set Destinations value
     * @param \ArrayType\ArrayOfJP_Destination $destinations
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public function setDestinations(\ArrayType\ArrayOfJP_Destination $destinations = null)
    {
        $this->Destinations = $destinations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServiceAdditionalElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
