<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelRoomContract StructType
 * @subpackage Structs
 */
class JP_HotelRoomContract extends AbstractStructBase
{
    /**
     * The IsSalesContract
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsSalesContract;
    /**
     * The Type
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Type;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The BrandRating
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BrandRating;
    /**
     * The Days
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfInt1
     */
    public $Days;
    /**
     * The IntCode
     * @var string
     */
    public $IntCode;
    /**
     * The ExternalType
     * @var string
     */
    public $ExternalType;
    /**
     * Constructor method for JP_HotelRoomContract
     * @uses JP_HotelRoomContract::setIsSalesContract()
     * @uses JP_HotelRoomContract::setType()
     * @uses JP_HotelRoomContract::setName()
     * @uses JP_HotelRoomContract::setBrandRating()
     * @uses JP_HotelRoomContract::setDays()
     * @uses JP_HotelRoomContract::setIntCode()
     * @uses JP_HotelRoomContract::setExternalType()
     * @param bool $isSalesContract
     * @param string $type
     * @param string $name
     * @param string $brandRating
     * @param \ArrayType\ArrayOfInt1 $days
     * @param string $intCode
     * @param string $externalType
     */
    public function __construct($isSalesContract = null, $type = null, $name = null, $brandRating = null, \ArrayType\ArrayOfInt1 $days = null, $intCode = null, $externalType = null)
    {
        $this
            ->setIsSalesContract($isSalesContract)
            ->setType($type)
            ->setName($name)
            ->setBrandRating($brandRating)
            ->setDays($days)
            ->setIntCode($intCode)
            ->setExternalType($externalType);
    }
    /**
     * Get IsSalesContract value
     * @return bool
     */
    public function getIsSalesContract()
    {
        return $this->IsSalesContract;
    }
    /**
     * Set IsSalesContract value
     * @param bool $isSalesContract
     * @return \StructType\JP_HotelRoomContract
     */
    public function setIsSalesContract($isSalesContract = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSalesContract) && !is_bool($isSalesContract)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSalesContract, true), gettype($isSalesContract)), __LINE__);
        }
        $this->IsSalesContract = $isSalesContract;
        return $this;
    }
    /**
     * Get Type value
     * @return string
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\JP_ContractType::valueIsValid()
     * @uses \EnumType\JP_ContractType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\JP_HotelRoomContract
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ContractType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JP_ContractType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\JP_ContractType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_HotelRoomContract
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get BrandRating value
     * @return string|null
     */
    public function getBrandRating()
    {
        return $this->BrandRating;
    }
    /**
     * Set BrandRating value
     * @param string $brandRating
     * @return \StructType\JP_HotelRoomContract
     */
    public function setBrandRating($brandRating = null)
    {
        // validation for constraint: string
        if (!is_null($brandRating) && !is_string($brandRating)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandRating, true), gettype($brandRating)), __LINE__);
        }
        $this->BrandRating = $brandRating;
        return $this;
    }
    /**
     * Get Days value
     * @return \ArrayType\ArrayOfInt1|null
     */
    public function getDays()
    {
        return $this->Days;
    }
    /**
     * Set Days value
     * @param \ArrayType\ArrayOfInt1 $days
     * @return \StructType\JP_HotelRoomContract
     */
    public function setDays(\ArrayType\ArrayOfInt1 $days = null)
    {
        $this->Days = $days;
        return $this;
    }
    /**
     * Get IntCode value
     * @return string|null
     */
    public function getIntCode()
    {
        return $this->IntCode;
    }
    /**
     * Set IntCode value
     * @param string $intCode
     * @return \StructType\JP_HotelRoomContract
     */
    public function setIntCode($intCode = null)
    {
        // validation for constraint: string
        if (!is_null($intCode) && !is_string($intCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($intCode, true), gettype($intCode)), __LINE__);
        }
        $this->IntCode = $intCode;
        return $this;
    }
    /**
     * Get ExternalType value
     * @return string|null
     */
    public function getExternalType()
    {
        return $this->ExternalType;
    }
    /**
     * Set ExternalType value
     * @param string $externalType
     * @return \StructType\JP_HotelRoomContract
     */
    public function setExternalType($externalType = null)
    {
        // validation for constraint: string
        if (!is_null($externalType) && !is_string($externalType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalType, true), gettype($externalType)), __LINE__);
        }
        $this->ExternalType = $externalType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelRoomContract
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
