<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_FinalCustomerData StructType
 * @subpackage Structs
 */
class JP_FinalCustomerData extends AbstractStructBase
{
    /**
     * The IsCorporative
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $IsCorporative;
    /**
     * The AcceptOfferMailing
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $AcceptOfferMailing;
    /**
     * The Active
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $Active;
    /**
     * The Code
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var int
     */
    public $Code;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Surname
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Surname;
    /**
     * The ContactData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_FinalCustomerContactData
     */
    public $ContactData;
    /**
     * The Document
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Document
     */
    public $Document;
    /**
     * The Password
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Password;
    /**
     * The Comments
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Comment
     */
    public $Comments;
    /**
     * Constructor method for JP_FinalCustomerData
     * @uses JP_FinalCustomerData::setIsCorporative()
     * @uses JP_FinalCustomerData::setAcceptOfferMailing()
     * @uses JP_FinalCustomerData::setActive()
     * @uses JP_FinalCustomerData::setCode()
     * @uses JP_FinalCustomerData::setName()
     * @uses JP_FinalCustomerData::setSurname()
     * @uses JP_FinalCustomerData::setContactData()
     * @uses JP_FinalCustomerData::setDocument()
     * @uses JP_FinalCustomerData::setPassword()
     * @uses JP_FinalCustomerData::setComments()
     * @param bool $isCorporative
     * @param bool $acceptOfferMailing
     * @param bool $active
     * @param int $code
     * @param string $name
     * @param string $surname
     * @param \StructType\JP_FinalCustomerContactData $contactData
     * @param \StructType\JP_Document $document
     * @param string $password
     * @param \ArrayType\ArrayOfJP_Comment $comments
     */
    public function __construct($isCorporative = null, $acceptOfferMailing = null, $active = null, $code = null, $name = null, $surname = null, \StructType\JP_FinalCustomerContactData $contactData = null, \StructType\JP_Document $document = null, $password = null, \ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this
            ->setIsCorporative($isCorporative)
            ->setAcceptOfferMailing($acceptOfferMailing)
            ->setActive($active)
            ->setCode($code)
            ->setName($name)
            ->setSurname($surname)
            ->setContactData($contactData)
            ->setDocument($document)
            ->setPassword($password)
            ->setComments($comments);
    }
    /**
     * Get IsCorporative value
     * @return bool
     */
    public function getIsCorporative()
    {
        return $this->IsCorporative;
    }
    /**
     * Set IsCorporative value
     * @param bool $isCorporative
     * @return \StructType\JP_FinalCustomerData
     */
    public function setIsCorporative($isCorporative = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCorporative) && !is_bool($isCorporative)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCorporative, true), gettype($isCorporative)), __LINE__);
        }
        $this->IsCorporative = $isCorporative;
        return $this;
    }
    /**
     * Get AcceptOfferMailing value
     * @return bool
     */
    public function getAcceptOfferMailing()
    {
        return $this->AcceptOfferMailing;
    }
    /**
     * Set AcceptOfferMailing value
     * @param bool $acceptOfferMailing
     * @return \StructType\JP_FinalCustomerData
     */
    public function setAcceptOfferMailing($acceptOfferMailing = null)
    {
        // validation for constraint: boolean
        if (!is_null($acceptOfferMailing) && !is_bool($acceptOfferMailing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($acceptOfferMailing, true), gettype($acceptOfferMailing)), __LINE__);
        }
        $this->AcceptOfferMailing = $acceptOfferMailing;
        return $this;
    }
    /**
     * Get Active value
     * @return bool
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \StructType\JP_FinalCustomerData
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Code value
     * @return int|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param int $code
     * @return \StructType\JP_FinalCustomerData
     */
    public function setCode($code = null)
    {
        // validation for constraint: int
        if (!is_null($code) && !(is_int($code) || ctype_digit($code))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_FinalCustomerData
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Surname value
     * @return string|null
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\JP_FinalCustomerData
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get ContactData value
     * @return \StructType\JP_FinalCustomerContactData|null
     */
    public function getContactData()
    {
        return $this->ContactData;
    }
    /**
     * Set ContactData value
     * @param \StructType\JP_FinalCustomerContactData $contactData
     * @return \StructType\JP_FinalCustomerData
     */
    public function setContactData(\StructType\JP_FinalCustomerContactData $contactData = null)
    {
        $this->ContactData = $contactData;
        return $this;
    }
    /**
     * Get Document value
     * @return \StructType\JP_Document|null
     */
    public function getDocument()
    {
        return $this->Document;
    }
    /**
     * Set Document value
     * @param \StructType\JP_Document $document
     * @return \StructType\JP_FinalCustomerData
     */
    public function setDocument(\StructType\JP_Document $document = null)
    {
        $this->Document = $document;
        return $this;
    }
    /**
     * Get Password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->Password;
    }
    /**
     * Set Password value
     * @param string $password
     * @return \StructType\JP_FinalCustomerData
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($password, true), gettype($password)), __LINE__);
        }
        $this->Password = $password;
        return $this;
    }
    /**
     * Get Comments value
     * @return \ArrayType\ArrayOfJP_Comment|null
     */
    public function getComments()
    {
        return $this->Comments;
    }
    /**
     * Set Comments value
     * @param \ArrayType\ArrayOfJP_Comment $comments
     * @return \StructType\JP_FinalCustomerData
     */
    public function setComments(\ArrayType\ArrayOfJP_Comment $comments = null)
    {
        $this->Comments = $comments;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_FinalCustomerData
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
