<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseResult StructType
 * @subpackage Structs
 */
class JP_CruiseResult extends AbstractStructBase
{
    /**
     * The Sea
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Sea;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Ship
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Ship
     */
    public $Ship;
    /**
     * The Itinerary
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseItinerary
     */
    public $Itinerary;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The Categories
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_CruiseCategory
     */
    public $Categories;
    /**
     * The StarDays
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CruiseStarDay[]
     */
    public $StarDays;
    /**
     * The BookingCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_BookingCode
     */
    public $BookingCode;
    /**
     * The CruiseRequiredFields
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseRequiredFields
     */
    public $CruiseRequiredFields;
    /**
     * The PriceInformation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruisePriceInformation
     */
    public $PriceInformation;
    /**
     * The RelPaxesDist
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_RelPaxDist
     */
    public $RelPaxesDist;
    /**
     * The OptionalElements
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_CruiseOptionalElements
     */
    public $OptionalElements;
    /**
     * The CruiseCode
     * @var string
     */
    public $CruiseCode;
    /**
     * The Zone
     * @var int
     */
    public $Zone;
    /**
     * The StartDate
     * @var string
     */
    public $StartDate;
    /**
     * The DaysDuration
     * @var int
     */
    public $DaysDuration;
    /**
     * The RatePlanCode
     * @var string
     */
    public $RatePlanCode;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The IncludeFlight
     * @var bool
     */
    public $IncludeFlight;
    /**
     * Constructor method for JP_CruiseResult
     * @uses JP_CruiseResult::setSea()
     * @uses JP_CruiseResult::setName()
     * @uses JP_CruiseResult::setShip()
     * @uses JP_CruiseResult::setItinerary()
     * @uses JP_CruiseResult::setDescription()
     * @uses JP_CruiseResult::setCategories()
     * @uses JP_CruiseResult::setStarDays()
     * @uses JP_CruiseResult::setBookingCode()
     * @uses JP_CruiseResult::setCruiseRequiredFields()
     * @uses JP_CruiseResult::setPriceInformation()
     * @uses JP_CruiseResult::setRelPaxesDist()
     * @uses JP_CruiseResult::setOptionalElements()
     * @uses JP_CruiseResult::setCruiseCode()
     * @uses JP_CruiseResult::setZone()
     * @uses JP_CruiseResult::setStartDate()
     * @uses JP_CruiseResult::setDaysDuration()
     * @uses JP_CruiseResult::setRatePlanCode()
     * @uses JP_CruiseResult::setStatus()
     * @uses JP_CruiseResult::setIncludeFlight()
     * @param string $sea
     * @param string $name
     * @param \StructType\JP_Ship $ship
     * @param \StructType\JP_CruiseItinerary $itinerary
     * @param string $description
     * @param \ArrayType\ArrayOfJP_CruiseCategory $categories
     * @param \StructType\JP_CruiseStarDay[] $starDays
     * @param \StructType\JP_BookingCode $bookingCode
     * @param \StructType\JP_CruiseRequiredFields $cruiseRequiredFields
     * @param \StructType\JP_CruisePriceInformation $priceInformation
     * @param \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist
     * @param \StructType\JP_CruiseOptionalElements $optionalElements
     * @param string $cruiseCode
     * @param int $zone
     * @param string $startDate
     * @param int $daysDuration
     * @param string $ratePlanCode
     * @param string $status
     * @param bool $includeFlight
     */
    public function __construct($sea = null, $name = null, \StructType\JP_Ship $ship = null, \StructType\JP_CruiseItinerary $itinerary = null, $description = null, \ArrayType\ArrayOfJP_CruiseCategory $categories = null, array $starDays = array(), \StructType\JP_BookingCode $bookingCode = null, \StructType\JP_CruiseRequiredFields $cruiseRequiredFields = null, \StructType\JP_CruisePriceInformation $priceInformation = null, \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist = null, \StructType\JP_CruiseOptionalElements $optionalElements = null, $cruiseCode = null, $zone = null, $startDate = null, $daysDuration = null, $ratePlanCode = null, $status = null, $includeFlight = null)
    {
        $this
            ->setSea($sea)
            ->setName($name)
            ->setShip($ship)
            ->setItinerary($itinerary)
            ->setDescription($description)
            ->setCategories($categories)
            ->setStarDays($starDays)
            ->setBookingCode($bookingCode)
            ->setCruiseRequiredFields($cruiseRequiredFields)
            ->setPriceInformation($priceInformation)
            ->setRelPaxesDist($relPaxesDist)
            ->setOptionalElements($optionalElements)
            ->setCruiseCode($cruiseCode)
            ->setZone($zone)
            ->setStartDate($startDate)
            ->setDaysDuration($daysDuration)
            ->setRatePlanCode($ratePlanCode)
            ->setStatus($status)
            ->setIncludeFlight($includeFlight);
    }
    /**
     * Get Sea value
     * @return string|null
     */
    public function getSea()
    {
        return $this->Sea;
    }
    /**
     * Set Sea value
     * @param string $sea
     * @return \StructType\JP_CruiseResult
     */
    public function setSea($sea = null)
    {
        // validation for constraint: string
        if (!is_null($sea) && !is_string($sea)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sea, true), gettype($sea)), __LINE__);
        }
        $this->Sea = $sea;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CruiseResult
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Ship value
     * @return \StructType\JP_Ship|null
     */
    public function getShip()
    {
        return $this->Ship;
    }
    /**
     * Set Ship value
     * @param \StructType\JP_Ship $ship
     * @return \StructType\JP_CruiseResult
     */
    public function setShip(\StructType\JP_Ship $ship = null)
    {
        $this->Ship = $ship;
        return $this;
    }
    /**
     * Get Itinerary value
     * @return \StructType\JP_CruiseItinerary|null
     */
    public function getItinerary()
    {
        return $this->Itinerary;
    }
    /**
     * Set Itinerary value
     * @param \StructType\JP_CruiseItinerary $itinerary
     * @return \StructType\JP_CruiseResult
     */
    public function setItinerary(\StructType\JP_CruiseItinerary $itinerary = null)
    {
        $this->Itinerary = $itinerary;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\JP_CruiseResult
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get Categories value
     * @return \ArrayType\ArrayOfJP_CruiseCategory|null
     */
    public function getCategories()
    {
        return $this->Categories;
    }
    /**
     * Set Categories value
     * @param \ArrayType\ArrayOfJP_CruiseCategory $categories
     * @return \StructType\JP_CruiseResult
     */
    public function setCategories(\ArrayType\ArrayOfJP_CruiseCategory $categories = null)
    {
        $this->Categories = $categories;
        return $this;
    }
    /**
     * Get StarDays value
     * @return \StructType\JP_CruiseStarDay[]|null
     */
    public function getStarDays()
    {
        return $this->StarDays;
    }
    /**
     * This method is responsible for validating the values passed to the setStarDays method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStarDays method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStarDaysForArrayConstraintsFromSetStarDays(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jP_CruiseResultStarDaysItem) {
            // validation for constraint: itemType
            if (!$jP_CruiseResultStarDaysItem instanceof \StructType\JP_CruiseStarDay) {
                $invalidValues[] = is_object($jP_CruiseResultStarDaysItem) ? get_class($jP_CruiseResultStarDaysItem) : sprintf('%s(%s)', gettype($jP_CruiseResultStarDaysItem), var_export($jP_CruiseResultStarDaysItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The StarDays property can only contain items of type \StructType\JP_CruiseStarDay, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StarDays value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseStarDay[] $starDays
     * @return \StructType\JP_CruiseResult
     */
    public function setStarDays(array $starDays = array())
    {
        // validation for constraint: array
        if ('' !== ($starDaysArrayErrorMessage = self::validateStarDaysForArrayConstraintsFromSetStarDays($starDays))) {
            throw new \InvalidArgumentException($starDaysArrayErrorMessage, __LINE__);
        }
        $this->StarDays = $starDays;
        return $this;
    }
    /**
     * Add item to StarDays value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CruiseStarDay $item
     * @return \StructType\JP_CruiseResult
     */
    public function addToStarDays(\StructType\JP_CruiseStarDay $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CruiseStarDay) {
            throw new \InvalidArgumentException(sprintf('The StarDays property can only contain items of type \StructType\JP_CruiseStarDay, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->StarDays[] = $item;
        return $this;
    }
    /**
     * Get BookingCode value
     * @return \StructType\JP_BookingCode|null
     */
    public function getBookingCode()
    {
        return $this->BookingCode;
    }
    /**
     * Set BookingCode value
     * @param \StructType\JP_BookingCode $bookingCode
     * @return \StructType\JP_CruiseResult
     */
    public function setBookingCode(\StructType\JP_BookingCode $bookingCode = null)
    {
        $this->BookingCode = $bookingCode;
        return $this;
    }
    /**
     * Get CruiseRequiredFields value
     * @return \StructType\JP_CruiseRequiredFields|null
     */
    public function getCruiseRequiredFields()
    {
        return $this->CruiseRequiredFields;
    }
    /**
     * Set CruiseRequiredFields value
     * @param \StructType\JP_CruiseRequiredFields $cruiseRequiredFields
     * @return \StructType\JP_CruiseResult
     */
    public function setCruiseRequiredFields(\StructType\JP_CruiseRequiredFields $cruiseRequiredFields = null)
    {
        $this->CruiseRequiredFields = $cruiseRequiredFields;
        return $this;
    }
    /**
     * Get PriceInformation value
     * @return \StructType\JP_CruisePriceInformation|null
     */
    public function getPriceInformation()
    {
        return $this->PriceInformation;
    }
    /**
     * Set PriceInformation value
     * @param \StructType\JP_CruisePriceInformation $priceInformation
     * @return \StructType\JP_CruiseResult
     */
    public function setPriceInformation(\StructType\JP_CruisePriceInformation $priceInformation = null)
    {
        $this->PriceInformation = $priceInformation;
        return $this;
    }
    /**
     * Get RelPaxesDist value
     * @return \ArrayType\ArrayOfJP_RelPaxDist|null
     */
    public function getRelPaxesDist()
    {
        return $this->RelPaxesDist;
    }
    /**
     * Set RelPaxesDist value
     * @param \ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist
     * @return \StructType\JP_CruiseResult
     */
    public function setRelPaxesDist(\ArrayType\ArrayOfJP_RelPaxDist $relPaxesDist = null)
    {
        $this->RelPaxesDist = $relPaxesDist;
        return $this;
    }
    /**
     * Get OptionalElements value
     * @return \StructType\JP_CruiseOptionalElements|null
     */
    public function getOptionalElements()
    {
        return $this->OptionalElements;
    }
    /**
     * Set OptionalElements value
     * @param \StructType\JP_CruiseOptionalElements $optionalElements
     * @return \StructType\JP_CruiseResult
     */
    public function setOptionalElements(\StructType\JP_CruiseOptionalElements $optionalElements = null)
    {
        $this->OptionalElements = $optionalElements;
        return $this;
    }
    /**
     * Get CruiseCode value
     * @return string|null
     */
    public function getCruiseCode()
    {
        return $this->CruiseCode;
    }
    /**
     * Set CruiseCode value
     * @param string $cruiseCode
     * @return \StructType\JP_CruiseResult
     */
    public function setCruiseCode($cruiseCode = null)
    {
        // validation for constraint: string
        if (!is_null($cruiseCode) && !is_string($cruiseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cruiseCode, true), gettype($cruiseCode)), __LINE__);
        }
        $this->CruiseCode = $cruiseCode;
        return $this;
    }
    /**
     * Get Zone value
     * @return int|null
     */
    public function getZone()
    {
        return $this->Zone;
    }
    /**
     * Set Zone value
     * @param int $zone
     * @return \StructType\JP_CruiseResult
     */
    public function setZone($zone = null)
    {
        // validation for constraint: int
        if (!is_null($zone) && !(is_int($zone) || ctype_digit($zone))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($zone, true), gettype($zone)), __LINE__);
        }
        $this->Zone = $zone;
        return $this;
    }
    /**
     * Get StartDate value
     * @return string|null
     */
    public function getStartDate()
    {
        return $this->StartDate;
    }
    /**
     * Set StartDate value
     * @param string $startDate
     * @return \StructType\JP_CruiseResult
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        $this->StartDate = $startDate;
        return $this;
    }
    /**
     * Get DaysDuration value
     * @return int|null
     */
    public function getDaysDuration()
    {
        return $this->DaysDuration;
    }
    /**
     * Set DaysDuration value
     * @param int $daysDuration
     * @return \StructType\JP_CruiseResult
     */
    public function setDaysDuration($daysDuration = null)
    {
        // validation for constraint: int
        if (!is_null($daysDuration) && !(is_int($daysDuration) || ctype_digit($daysDuration))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($daysDuration, true), gettype($daysDuration)), __LINE__);
        }
        $this->DaysDuration = $daysDuration;
        return $this;
    }
    /**
     * Get RatePlanCode value
     * @return string|null
     */
    public function getRatePlanCode()
    {
        return $this->RatePlanCode;
    }
    /**
     * Set RatePlanCode value
     * @param string $ratePlanCode
     * @return \StructType\JP_CruiseResult
     */
    public function setRatePlanCode($ratePlanCode = null)
    {
        // validation for constraint: string
        if (!is_null($ratePlanCode) && !is_string($ratePlanCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ratePlanCode, true), gettype($ratePlanCode)), __LINE__);
        }
        $this->RatePlanCode = $ratePlanCode;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @param string $status
     * @return \StructType\JP_CruiseResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get IncludeFlight value
     * @return bool|null
     */
    public function getIncludeFlight()
    {
        return $this->IncludeFlight;
    }
    /**
     * Set IncludeFlight value
     * @param bool $includeFlight
     * @return \StructType\JP_CruiseResult
     */
    public function setIncludeFlight($includeFlight = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeFlight) && !is_bool($includeFlight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeFlight, true), gettype($includeFlight)), __LINE__);
        }
        $this->IncludeFlight = $includeFlight;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseResult
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
