<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CarFee StructType
 * @subpackage Structs
 */
class JP_CarFee extends AbstractStructBase
{
    /**
     * The PaymentOffice
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $PaymentOffice;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $Amount;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The PriceType
     * @var int
     */
    public $PriceType;
    /**
     * The Currency
     * @var string
     */
    public $Currency;
    /**
     * Constructor method for JP_CarFee
     * @uses JP_CarFee::setPaymentOffice()
     * @uses JP_CarFee::setAmount()
     * @uses JP_CarFee::setName()
     * @uses JP_CarFee::setPriceType()
     * @uses JP_CarFee::setCurrency()
     * @param bool $paymentOffice
     * @param float $amount
     * @param string $name
     * @param int $priceType
     * @param string $currency
     */
    public function __construct($paymentOffice = null, $amount = null, $name = null, $priceType = null, $currency = null)
    {
        $this
            ->setPaymentOffice($paymentOffice)
            ->setAmount($amount)
            ->setName($name)
            ->setPriceType($priceType)
            ->setCurrency($currency);
    }
    /**
     * Get PaymentOffice value
     * @return bool
     */
    public function getPaymentOffice()
    {
        return $this->PaymentOffice;
    }
    /**
     * Set PaymentOffice value
     * @param bool $paymentOffice
     * @return \StructType\JP_CarFee
     */
    public function setPaymentOffice($paymentOffice = null)
    {
        // validation for constraint: boolean
        if (!is_null($paymentOffice) && !is_bool($paymentOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($paymentOffice, true), gettype($paymentOffice)), __LINE__);
        }
        $this->PaymentOffice = $paymentOffice;
        return $this;
    }
    /**
     * Get Amount value
     * @return float
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\JP_CarFee
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_CarFee
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get PriceType value
     * @return int|null
     */
    public function getPriceType()
    {
        return $this->PriceType;
    }
    /**
     * Set PriceType value
     * @param int $priceType
     * @return \StructType\JP_CarFee
     */
    public function setPriceType($priceType = null)
    {
        // validation for constraint: int
        if (!is_null($priceType) && !(is_int($priceType) || ctype_digit($priceType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceType, true), gettype($priceType)), __LINE__);
        }
        $this->PriceType = $priceType;
        return $this;
    }
    /**
     * Get Currency value
     * @return string|null
     */
    public function getCurrency()
    {
        return $this->Currency;
    }
    /**
     * Set Currency value
     * @param string $currency
     * @return \StructType\JP_CarFee
     */
    public function setCurrency($currency = null)
    {
        // validation for constraint: string
        if (!is_null($currency) && !is_string($currency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currency, true), gettype($currency)), __LINE__);
        }
        $this->Currency = $currency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CarFee
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
