<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_SuppleOfferPrices StructType
 * @subpackage Structs
 */
class JPSOAP_SuppleOfferPrices extends AbstractStructBase
{
    /**
     * The PricePer
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PricePer;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_SuppleOfferPrice[]
     */
    public $Price;
    /**
     * Constructor method for JPSOAP_SuppleOfferPrices
     * @uses JPSOAP_SuppleOfferPrices::setPricePer()
     * @uses JPSOAP_SuppleOfferPrices::setPrice()
     * @param string $pricePer
     * @param \StructType\JPSOAP_SuppleOfferPrice[] $price
     */
    public function __construct($pricePer = null, array $price = array())
    {
        $this
            ->setPricePer($pricePer)
            ->setPrice($price);
    }
    /**
     * Get PricePer value
     * @return string
     */
    public function getPricePer()
    {
        return $this->PricePer;
    }
    /**
     * Set PricePer value
     * @uses \EnumType\JPSOAP_PricePerTypes::valueIsValid()
     * @uses \EnumType\JPSOAP_PricePerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricePer
     * @return \StructType\JPSOAP_SuppleOfferPrices
     */
    public function setPricePer($pricePer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_PricePerTypes::valueIsValid($pricePer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\JPSOAP_PricePerTypes', is_array($pricePer) ? implode(', ', $pricePer) : var_export($pricePer, true), implode(', ', \EnumType\JPSOAP_PricePerTypes::getValidValues())), __LINE__);
        }
        $this->PricePer = $pricePer;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\JPSOAP_SuppleOfferPrice[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * This method is responsible for validating the values passed to the setPrice method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPrice method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePriceForArrayConstraintsFromSetPrice(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $jPSOAP_SuppleOfferPricesPriceItem) {
            // validation for constraint: itemType
            if (!$jPSOAP_SuppleOfferPricesPriceItem instanceof \StructType\JPSOAP_SuppleOfferPrice) {
                $invalidValues[] = is_object($jPSOAP_SuppleOfferPricesPriceItem) ? get_class($jPSOAP_SuppleOfferPricesPriceItem) : sprintf('%s(%s)', gettype($jPSOAP_SuppleOfferPricesPriceItem), var_export($jPSOAP_SuppleOfferPricesPriceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Price property can only contain items of type \StructType\JPSOAP_SuppleOfferPrice, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_SuppleOfferPrice[] $price
     * @return \StructType\JPSOAP_SuppleOfferPrices
     */
    public function setPrice(array $price = array())
    {
        // validation for constraint: array
        if ('' !== ($priceArrayErrorMessage = self::validatePriceForArrayConstraintsFromSetPrice($price))) {
            throw new \InvalidArgumentException($priceArrayErrorMessage, __LINE__);
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_SuppleOfferPrice $item
     * @return \StructType\JPSOAP_SuppleOfferPrices
     */
    public function addToPrice(\StructType\JPSOAP_SuppleOfferPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_SuppleOfferPrice) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of type \StructType\JPSOAP_SuppleOfferPrice, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_SuppleOfferPrices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
