<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_PropertyType ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_PropertyType extends AbstractStructArrayBase
{
    /**
     * The PropertyType
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PropertyType[]
     */
    public $PropertyType;
    /**
     * Constructor method for ArrayOfJP_PropertyType
     * @uses ArrayOfJP_PropertyType::setPropertyType()
     * @param \StructType\JP_PropertyType[] $propertyType
     */
    public function __construct(array $propertyType = array())
    {
        $this
            ->setPropertyType($propertyType);
    }
    /**
     * Get PropertyType value
     * @return \StructType\JP_PropertyType[]|null
     */
    public function getPropertyType()
    {
        return $this->PropertyType;
    }
    /**
     * This method is responsible for validating the values passed to the setPropertyType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPropertyType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePropertyTypeForArrayConstraintsFromSetPropertyType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfJP_PropertyTypePropertyTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PropertyTypePropertyTypeItem instanceof \StructType\JP_PropertyType) {
                $invalidValues[] = is_object($arrayOfJP_PropertyTypePropertyTypeItem) ? get_class($arrayOfJP_PropertyTypePropertyTypeItem) : sprintf('%s(%s)', gettype($arrayOfJP_PropertyTypePropertyTypeItem), var_export($arrayOfJP_PropertyTypePropertyTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PropertyType property can only contain items of type \StructType\JP_PropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PropertyType value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PropertyType[] $propertyType
     * @return \ArrayType\ArrayOfJP_PropertyType
     */
    public function setPropertyType(array $propertyType = array())
    {
        // validation for constraint: array
        if ('' !== ($propertyTypeArrayErrorMessage = self::validatePropertyTypeForArrayConstraintsFromSetPropertyType($propertyType))) {
            throw new \InvalidArgumentException($propertyTypeArrayErrorMessage, __LINE__);
        }
        $this->PropertyType = $propertyType;
        return $this;
    }
    /**
     * Add item to PropertyType value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PropertyType $item
     * @return \ArrayType\ArrayOfJP_PropertyType
     */
    public function addToPropertyType(\StructType\JP_PropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PropertyType) {
            throw new \InvalidArgumentException(sprintf('The PropertyType property can only contain items of type \StructType\JP_PropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PropertyType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_PropertyType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_PropertyType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_PropertyType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_PropertyType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_PropertyType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PropertyType
     */
    public function getAttributeName()
    {
        return 'PropertyType';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_PropertyType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
