<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_FlightElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_FlightElement extends AbstractStructArrayBase
{
    /**
     * The FlightElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_FlightElement[]
     */
    public $FlightElement;
    /**
     * Constructor method for ArrayOfJP_FlightElement
     * @uses ArrayOfJP_FlightElement::setFlightElement()
     * @param \StructType\JP_FlightElement[] $flightElement
     */
    public function __construct(array $flightElement = array())
    {
        $this
            ->setFlightElement($flightElement);
    }
    /**
     * Get FlightElement value
     * @return \StructType\JP_FlightElement[]|null
     */
    public function getFlightElement()
    {
        return $this->FlightElement;
    }
    /**
     * Set FlightElement value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FlightElement[] $flightElement
     * @return \ArrayType\ArrayOfJP_FlightElement
     */
    public function setFlightElement(array $flightElement = array())
    {
        foreach ($flightElement as $arrayOfJP_FlightElementFlightElementItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_FlightElementFlightElementItem instanceof \StructType\JP_FlightElement) {
                throw new \InvalidArgumentException(sprintf('The FlightElement property can only contain items of \StructType\JP_FlightElement, "%s" given', is_object($arrayOfJP_FlightElementFlightElementItem) ? get_class($arrayOfJP_FlightElementFlightElementItem) : gettype($arrayOfJP_FlightElementFlightElementItem)), __LINE__);
            }
        }
        $this->FlightElement = $flightElement;
        return $this;
    }
    /**
     * Add item to FlightElement value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_FlightElement $item
     * @return \ArrayType\ArrayOfJP_FlightElement
     */
    public function addToFlightElement(\StructType\JP_FlightElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_FlightElement) {
            throw new \InvalidArgumentException(sprintf('The FlightElement property can only contain items of \StructType\JP_FlightElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FlightElement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_FlightElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_FlightElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_FlightElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_FlightElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_FlightElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FlightElement
     */
    public function getAttributeName()
    {
        return 'FlightElement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_FlightElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
