<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_TransferContent StructType
 * @subpackage Structs
 */
class JP_TransferContent extends AbstractStructBase
{
    /**
     * The TransferContentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferContentInfo
     */
    public $TransferContentInfo;
    /**
     * The TransferZones
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_TransferZones
     */
    public $TransferZones;
    /**
     * The TransferOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_TransferContentOption
     */
    public $TransferOptions;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_TransferContent
     * @uses JP_TransferContent::setTransferContentInfo()
     * @uses JP_TransferContent::setTransferZones()
     * @uses JP_TransferContent::setTransferOptions()
     * @uses JP_TransferContent::setCode()
     * @param \StructType\JP_TransferContentInfo $transferContentInfo
     * @param \StructType\JP_TransferZones $transferZones
     * @param \ArrayType\ArrayOfJP_TransferContentOption $transferOptions
     * @param string $code
     */
    public function __construct(\StructType\JP_TransferContentInfo $transferContentInfo = null, \StructType\JP_TransferZones $transferZones = null, \ArrayType\ArrayOfJP_TransferContentOption $transferOptions = null, $code = null)
    {
        $this
            ->setTransferContentInfo($transferContentInfo)
            ->setTransferZones($transferZones)
            ->setTransferOptions($transferOptions)
            ->setCode($code);
    }
    /**
     * Get TransferContentInfo value
     * @return \StructType\JP_TransferContentInfo|null
     */
    public function getTransferContentInfo()
    {
        return $this->TransferContentInfo;
    }
    /**
     * Set TransferContentInfo value
     * @param \StructType\JP_TransferContentInfo $transferContentInfo
     * @return \StructType\JP_TransferContent
     */
    public function setTransferContentInfo(\StructType\JP_TransferContentInfo $transferContentInfo = null)
    {
        $this->TransferContentInfo = $transferContentInfo;
        return $this;
    }
    /**
     * Get TransferZones value
     * @return \StructType\JP_TransferZones|null
     */
    public function getTransferZones()
    {
        return $this->TransferZones;
    }
    /**
     * Set TransferZones value
     * @param \StructType\JP_TransferZones $transferZones
     * @return \StructType\JP_TransferContent
     */
    public function setTransferZones(\StructType\JP_TransferZones $transferZones = null)
    {
        $this->TransferZones = $transferZones;
        return $this;
    }
    /**
     * Get TransferOptions value
     * @return \ArrayType\ArrayOfJP_TransferContentOption|null
     */
    public function getTransferOptions()
    {
        return $this->TransferOptions;
    }
    /**
     * Set TransferOptions value
     * @param \ArrayType\ArrayOfJP_TransferContentOption $transferOptions
     * @return \StructType\JP_TransferContent
     */
    public function setTransferOptions(\ArrayType\ArrayOfJP_TransferContentOption $transferOptions = null)
    {
        $this->TransferOptions = $transferOptions;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_TransferContent
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_TransferContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
