<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ShoppingBasketSave StructType
 * @subpackage Structs
 */
class JP_ShoppingBasketSave extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The ShoppingBasket
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ShoppingBasket
     */
    public $ShoppingBasket;
    /**
     * The ShoppingBasketItems
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ShoppingBasketItems
     */
    public $ShoppingBasketItems;
    /**
     * The RestrictedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * Constructor method for JP_ShoppingBasketSave
     * @uses JP_ShoppingBasketSave::setLogin()
     * @uses JP_ShoppingBasketSave::setShoppingBasket()
     * @uses JP_ShoppingBasketSave::setShoppingBasketItems()
     * @uses JP_ShoppingBasketSave::setRestrictedOptions()
     * @uses JP_ShoppingBasketSave::setLanguage()
     * @uses JP_ShoppingBasketSave::setVersion()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_ShoppingBasket $shoppingBasket
     * @param \StructType\JP_ShoppingBasketItems $shoppingBasketItems
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $language
     * @param string $version
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_ShoppingBasket $shoppingBasket = null, \StructType\JP_ShoppingBasketItems $shoppingBasketItems = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $language = null, $version = null)
    {
        $this
            ->setLogin($login)
            ->setShoppingBasket($shoppingBasket)
            ->setShoppingBasketItems($shoppingBasketItems)
            ->setRestrictedOptions($restrictedOptions)
            ->setLanguage($language)
            ->setVersion($version);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_ShoppingBasketSave
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get ShoppingBasket value
     * @return \StructType\JP_ShoppingBasket|null
     */
    public function getShoppingBasket()
    {
        return $this->ShoppingBasket;
    }
    /**
     * Set ShoppingBasket value
     * @param \StructType\JP_ShoppingBasket $shoppingBasket
     * @return \StructType\JP_ShoppingBasketSave
     */
    public function setShoppingBasket(\StructType\JP_ShoppingBasket $shoppingBasket = null)
    {
        $this->ShoppingBasket = $shoppingBasket;
        return $this;
    }
    /**
     * Get ShoppingBasketItems value
     * @return \StructType\JP_ShoppingBasketItems|null
     */
    public function getShoppingBasketItems()
    {
        return $this->ShoppingBasketItems;
    }
    /**
     * Set ShoppingBasketItems value
     * @param \StructType\JP_ShoppingBasketItems $shoppingBasketItems
     * @return \StructType\JP_ShoppingBasketSave
     */
    public function setShoppingBasketItems(\StructType\JP_ShoppingBasketItems $shoppingBasketItems = null)
    {
        $this->ShoppingBasketItems = $shoppingBasketItems;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_ShoppingBasketSave
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_ShoppingBasketSave
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_ShoppingBasketSave
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ShoppingBasketSave
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
