<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PackageSearcherRequest StructType
 * @subpackage Structs
 */
class JP_PackageSearcherRequest extends AbstractStructBase
{
    /**
     * The Suppliers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Suppliers
     */
    public $Suppliers;
    /**
     * The DestinationZone
     * @var int
     */
    public $DestinationZone;
    /**
     * The OriginZone
     * @var int
     */
    public $OriginZone;
    /**
     * The Date
     * @var string
     */
    public $Date;
    /**
     * The Duration
     * @var int
     */
    public $Duration;
    /**
     * Constructor method for JP_PackageSearcherRequest
     * @uses JP_PackageSearcherRequest::setSuppliers()
     * @uses JP_PackageSearcherRequest::setDestinationZone()
     * @uses JP_PackageSearcherRequest::setOriginZone()
     * @uses JP_PackageSearcherRequest::setDate()
     * @uses JP_PackageSearcherRequest::setDuration()
     * @param \StructType\JP_Suppliers $suppliers
     * @param int $destinationZone
     * @param int $originZone
     * @param string $date
     * @param int $duration
     */
    public function __construct(\StructType\JP_Suppliers $suppliers = null, $destinationZone = null, $originZone = null, $date = null, $duration = null)
    {
        $this
            ->setSuppliers($suppliers)
            ->setDestinationZone($destinationZone)
            ->setOriginZone($originZone)
            ->setDate($date)
            ->setDuration($duration);
    }
    /**
     * Get Suppliers value
     * @return \StructType\JP_Suppliers|null
     */
    public function getSuppliers()
    {
        return $this->Suppliers;
    }
    /**
     * Set Suppliers value
     * @param \StructType\JP_Suppliers $suppliers
     * @return \StructType\JP_PackageSearcherRequest
     */
    public function setSuppliers(\StructType\JP_Suppliers $suppliers = null)
    {
        $this->Suppliers = $suppliers;
        return $this;
    }
    /**
     * Get DestinationZone value
     * @return int|null
     */
    public function getDestinationZone()
    {
        return $this->DestinationZone;
    }
    /**
     * Set DestinationZone value
     * @param int $destinationZone
     * @return \StructType\JP_PackageSearcherRequest
     */
    public function setDestinationZone($destinationZone = null)
    {
        // validation for constraint: int
        if (!is_null($destinationZone) && !is_numeric($destinationZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($destinationZone)), __LINE__);
        }
        $this->DestinationZone = $destinationZone;
        return $this;
    }
    /**
     * Get OriginZone value
     * @return int|null
     */
    public function getOriginZone()
    {
        return $this->OriginZone;
    }
    /**
     * Set OriginZone value
     * @param int $originZone
     * @return \StructType\JP_PackageSearcherRequest
     */
    public function setOriginZone($originZone = null)
    {
        // validation for constraint: int
        if (!is_null($originZone) && !is_numeric($originZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($originZone)), __LINE__);
        }
        $this->OriginZone = $originZone;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\JP_PackageSearcherRequest
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get Duration value
     * @return int|null
     */
    public function getDuration()
    {
        return $this->Duration;
    }
    /**
     * Set Duration value
     * @param int $duration
     * @return \StructType\JP_PackageSearcherRequest
     */
    public function setDuration($duration = null)
    {
        // validation for constraint: int
        if (!is_null($duration) && !is_numeric($duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($duration)), __LINE__);
        }
        $this->Duration = $duration;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PackageSearcherRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
