<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_TransferSimpleContent ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_TransferSimpleContent extends AbstractStructArrayBase
{
    /**
     * The Transfer
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_TransferSimpleContent[]
     */
    public $Transfer;
    /**
     * Constructor method for ArrayOfJP_TransferSimpleContent
     * @uses ArrayOfJP_TransferSimpleContent::setTransfer()
     * @param \StructType\JP_TransferSimpleContent[] $transfer
     */
    public function __construct(array $transfer = array())
    {
        $this
            ->setTransfer($transfer);
    }
    /**
     * Get Transfer value
     * @return \StructType\JP_TransferSimpleContent[]|null
     */
    public function getTransfer()
    {
        return $this->Transfer;
    }
    /**
     * Set Transfer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferSimpleContent[] $transfer
     * @return \ArrayType\ArrayOfJP_TransferSimpleContent
     */
    public function setTransfer(array $transfer = array())
    {
        foreach ($transfer as $arrayOfJP_TransferSimpleContentTransferItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_TransferSimpleContentTransferItem instanceof \StructType\JP_TransferSimpleContent) {
                throw new \InvalidArgumentException(sprintf('The Transfer property can only contain items of \StructType\JP_TransferSimpleContent, "%s" given', is_object($arrayOfJP_TransferSimpleContentTransferItem) ? get_class($arrayOfJP_TransferSimpleContentTransferItem) : gettype($arrayOfJP_TransferSimpleContentTransferItem)), __LINE__);
            }
        }
        $this->Transfer = $transfer;
        return $this;
    }
    /**
     * Add item to Transfer value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferSimpleContent $item
     * @return \ArrayType\ArrayOfJP_TransferSimpleContent
     */
    public function addToTransfer(\StructType\JP_TransferSimpleContent $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_TransferSimpleContent) {
            throw new \InvalidArgumentException(sprintf('The Transfer property can only contain items of \StructType\JP_TransferSimpleContent, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Transfer[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_TransferSimpleContent|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_TransferSimpleContent|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_TransferSimpleContent|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_TransferSimpleContent|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_TransferSimpleContent|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Transfer
     */
    public function getAttributeName()
    {
        return 'Transfer';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_TransferSimpleContent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
