<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_TransferElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_TransferElement extends AbstractStructArrayBase
{
    /**
     * The TransferElement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_TransferElement[]
     */
    public $TransferElement;
    /**
     * Constructor method for ArrayOfJP_TransferElement
     * @uses ArrayOfJP_TransferElement::setTransferElement()
     * @param \StructType\JP_TransferElement[] $transferElement
     */
    public function __construct(array $transferElement = array())
    {
        $this
            ->setTransferElement($transferElement);
    }
    /**
     * Get TransferElement value
     * @return \StructType\JP_TransferElement[]|null
     */
    public function getTransferElement()
    {
        return $this->TransferElement;
    }
    /**
     * Set TransferElement value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferElement[] $transferElement
     * @return \ArrayType\ArrayOfJP_TransferElement
     */
    public function setTransferElement(array $transferElement = array())
    {
        foreach ($transferElement as $arrayOfJP_TransferElementTransferElementItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_TransferElementTransferElementItem instanceof \StructType\JP_TransferElement) {
                throw new \InvalidArgumentException(sprintf('The TransferElement property can only contain items of \StructType\JP_TransferElement, "%s" given', is_object($arrayOfJP_TransferElementTransferElementItem) ? get_class($arrayOfJP_TransferElementTransferElementItem) : gettype($arrayOfJP_TransferElementTransferElementItem)), __LINE__);
            }
        }
        $this->TransferElement = $transferElement;
        return $this;
    }
    /**
     * Add item to TransferElement value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferElement $item
     * @return \ArrayType\ArrayOfJP_TransferElement
     */
    public function addToTransferElement(\StructType\JP_TransferElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_TransferElement) {
            throw new \InvalidArgumentException(sprintf('The TransferElement property can only contain items of \StructType\JP_TransferElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransferElement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_TransferElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_TransferElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_TransferElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_TransferElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_TransferElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransferElement
     */
    public function getAttributeName()
    {
        return 'TransferElement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_TransferElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
