<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_TransferContentOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_TransferContentOption extends AbstractStructArrayBase
{
    /**
     * The TransferOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_TransferContentOption[]
     */
    public $TransferOption;
    /**
     * Constructor method for ArrayOfJP_TransferContentOption
     * @uses ArrayOfJP_TransferContentOption::setTransferOption()
     * @param \StructType\JP_TransferContentOption[] $transferOption
     */
    public function __construct(array $transferOption = array())
    {
        $this
            ->setTransferOption($transferOption);
    }
    /**
     * Get TransferOption value
     * @return \StructType\JP_TransferContentOption[]|null
     */
    public function getTransferOption()
    {
        return $this->TransferOption;
    }
    /**
     * Set TransferOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferContentOption[] $transferOption
     * @return \ArrayType\ArrayOfJP_TransferContentOption
     */
    public function setTransferOption(array $transferOption = array())
    {
        foreach ($transferOption as $arrayOfJP_TransferContentOptionTransferOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_TransferContentOptionTransferOptionItem instanceof \StructType\JP_TransferContentOption) {
                throw new \InvalidArgumentException(sprintf('The TransferOption property can only contain items of \StructType\JP_TransferContentOption, "%s" given', is_object($arrayOfJP_TransferContentOptionTransferOptionItem) ? get_class($arrayOfJP_TransferContentOptionTransferOptionItem) : gettype($arrayOfJP_TransferContentOptionTransferOptionItem)), __LINE__);
            }
        }
        $this->TransferOption = $transferOption;
        return $this;
    }
    /**
     * Add item to TransferOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_TransferContentOption $item
     * @return \ArrayType\ArrayOfJP_TransferContentOption
     */
    public function addToTransferOption(\StructType\JP_TransferContentOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_TransferContentOption) {
            throw new \InvalidArgumentException(sprintf('The TransferOption property can only contain items of \StructType\JP_TransferContentOption, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->TransferOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_TransferContentOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_TransferContentOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_TransferContentOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_TransferContentOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_TransferContentOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TransferOption
     */
    public function getAttributeName()
    {
        return 'TransferOption';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_TransferContentOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
