<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ServiceAdditionalElement ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ServiceAdditionalElement extends AbstractStructArrayBase
{
    /**
     * The ServiceSupplement
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ServiceAdditionalElement[]
     */
    public $ServiceSupplement;
    /**
     * Constructor method for ArrayOfJP_ServiceAdditionalElement
     * @uses ArrayOfJP_ServiceAdditionalElement::setServiceSupplement()
     * @param \StructType\JP_ServiceAdditionalElement[] $serviceSupplement
     */
    public function __construct(array $serviceSupplement = array())
    {
        $this
            ->setServiceSupplement($serviceSupplement);
    }
    /**
     * Get ServiceSupplement value
     * @return \StructType\JP_ServiceAdditionalElement[]|null
     */
    public function getServiceSupplement()
    {
        return $this->ServiceSupplement;
    }
    /**
     * Set ServiceSupplement value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceAdditionalElement[] $serviceSupplement
     * @return \ArrayType\ArrayOfJP_ServiceAdditionalElement
     */
    public function setServiceSupplement(array $serviceSupplement = array())
    {
        foreach ($serviceSupplement as $arrayOfJP_ServiceAdditionalElementServiceSupplementItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ServiceAdditionalElementServiceSupplementItem instanceof \StructType\JP_ServiceAdditionalElement) {
                throw new \InvalidArgumentException(sprintf('The ServiceSupplement property can only contain items of \StructType\JP_ServiceAdditionalElement, "%s" given', is_object($arrayOfJP_ServiceAdditionalElementServiceSupplementItem) ? get_class($arrayOfJP_ServiceAdditionalElementServiceSupplementItem) : gettype($arrayOfJP_ServiceAdditionalElementServiceSupplementItem)), __LINE__);
            }
        }
        $this->ServiceSupplement = $serviceSupplement;
        return $this;
    }
    /**
     * Add item to ServiceSupplement value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceAdditionalElement $item
     * @return \ArrayType\ArrayOfJP_ServiceAdditionalElement
     */
    public function addToServiceSupplement(\StructType\JP_ServiceAdditionalElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ServiceAdditionalElement) {
            throw new \InvalidArgumentException(sprintf('The ServiceSupplement property can only contain items of \StructType\JP_ServiceAdditionalElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceSupplement[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ServiceAdditionalElement|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ServiceAdditionalElement|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ServiceAdditionalElement|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ServiceAdditionalElement|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ServiceAdditionalElement|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceSupplement
     */
    public function getAttributeName()
    {
        return 'ServiceSupplement';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_ServiceAdditionalElement
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
