<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JPSOAP_SuppleOfferPrices StructType
 * @subpackage Structs
 */
class JPSOAP_SuppleOfferPrices extends AbstractStructBase
{
    /**
     * The PricePer
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $PricePer;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_SuppleOfferPrice[]
     */
    public $Price;
    /**
     * Constructor method for JPSOAP_SuppleOfferPrices
     * @uses JPSOAP_SuppleOfferPrices::setPricePer()
     * @uses JPSOAP_SuppleOfferPrices::setPrice()
     * @param string $pricePer
     * @param \StructType\JPSOAP_SuppleOfferPrice[] $price
     */
    public function __construct($pricePer = null, array $price = array())
    {
        $this
            ->setPricePer($pricePer)
            ->setPrice($price);
    }
    /**
     * Get PricePer value
     * @return string
     */
    public function getPricePer()
    {
        return $this->PricePer;
    }
    /**
     * Set PricePer value
     * @uses \EnumType\JPSOAP_PricePerTypes::valueIsValid()
     * @uses \EnumType\JPSOAP_PricePerTypes::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pricePer
     * @return \StructType\JPSOAP_SuppleOfferPrices
     */
    public function setPricePer($pricePer = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JPSOAP_PricePerTypes::valueIsValid($pricePer)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $pricePer, implode(', ', \EnumType\JPSOAP_PricePerTypes::getValidValues())), __LINE__);
        }
        $this->PricePer = $pricePer;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\JPSOAP_SuppleOfferPrice[]|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_SuppleOfferPrice[] $price
     * @return \StructType\JPSOAP_SuppleOfferPrices
     */
    public function setPrice(array $price = array())
    {
        foreach ($price as $jPSOAP_SuppleOfferPricesPriceItem) {
            // validation for constraint: itemType
            if (!$jPSOAP_SuppleOfferPricesPriceItem instanceof \StructType\JPSOAP_SuppleOfferPrice) {
                throw new \InvalidArgumentException(sprintf('The Price property can only contain items of \StructType\JPSOAP_SuppleOfferPrice, "%s" given', is_object($jPSOAP_SuppleOfferPricesPriceItem) ? get_class($jPSOAP_SuppleOfferPricesPriceItem) : gettype($jPSOAP_SuppleOfferPricesPriceItem)), __LINE__);
            }
        }
        $this->Price = $price;
        return $this;
    }
    /**
     * Add item to Price value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_SuppleOfferPrice $item
     * @return \StructType\JPSOAP_SuppleOfferPrices
     */
    public function addToPrice(\StructType\JPSOAP_SuppleOfferPrice $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_SuppleOfferPrice) {
            throw new \InvalidArgumentException(sprintf('The Price property can only contain items of \StructType\JPSOAP_SuppleOfferPrice, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Price[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JPSOAP_SuppleOfferPrices
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
