<?php

namespace EnumType;

/**
 * This class stands for SuplementsType EnumType
 * @subpackage Enumerations
 */
class SuplementsType
{
    /**
     * Constant for value 'OTHERS'
     * @return string 'OTHERS'
     */
    const VALUE_OTHERS = 'OTHERS';
    /**
     * Constant for value 'DINING'
     * @return string 'DINING'
     */
    const VALUE_DINING = 'DINING';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_OTHERS
     * @uses self::VALUE_DINING
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_OTHERS,
            self::VALUE_DINING,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
