<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_PaxSeat ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_PaxSeat extends AbstractStructArrayBase
{
    /**
     * The PaxSeat
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_PaxSeat[]
     */
    public $PaxSeat;
    /**
     * Constructor method for ArrayOfJP_PaxSeat
     * @uses ArrayOfJP_PaxSeat::setPaxSeat()
     * @param \StructType\JP_PaxSeat[] $paxSeat
     */
    public function __construct(array $paxSeat = array())
    {
        $this
            ->setPaxSeat($paxSeat);
    }
    /**
     * Get PaxSeat value
     * @return \StructType\JP_PaxSeat[]|null
     */
    public function getPaxSeat()
    {
        return $this->PaxSeat;
    }
    /**
     * Set PaxSeat value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PaxSeat[] $paxSeat
     * @return \ArrayType\ArrayOfJP_PaxSeat
     */
    public function setPaxSeat(array $paxSeat = array())
    {
        foreach ($paxSeat as $arrayOfJP_PaxSeatPaxSeatItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_PaxSeatPaxSeatItem instanceof \StructType\JP_PaxSeat) {
                throw new \InvalidArgumentException(sprintf('The PaxSeat property can only contain items of \StructType\JP_PaxSeat, "%s" given', is_object($arrayOfJP_PaxSeatPaxSeatItem) ? get_class($arrayOfJP_PaxSeatPaxSeatItem) : gettype($arrayOfJP_PaxSeatPaxSeatItem)), __LINE__);
            }
        }
        $this->PaxSeat = $paxSeat;
        return $this;
    }
    /**
     * Add item to PaxSeat value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_PaxSeat $item
     * @return \ArrayType\ArrayOfJP_PaxSeat
     */
    public function addToPaxSeat(\StructType\JP_PaxSeat $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_PaxSeat) {
            throw new \InvalidArgumentException(sprintf('The PaxSeat property can only contain items of \StructType\JP_PaxSeat, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaxSeat[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_PaxSeat|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_PaxSeat|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_PaxSeat|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_PaxSeat|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_PaxSeat|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaxSeat
     */
    public function getAttributeName()
    {
        return 'PaxSeat';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_PaxSeat
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
