<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ZoneListRequest StructType
 * @subpackage Structs
 */
class JP_ZoneListRequest extends AbstractStructBase
{
    /**
     * The ProductType
     * @var string
     */
    public $ProductType;
    /**
     * The ShowIATA
     * @var bool
     */
    public $ShowIATA;
    /**
     * The MaxLevel
     * @var int
     */
    public $MaxLevel;
    /**
     * Constructor method for JP_ZoneListRequest
     * @uses JP_ZoneListRequest::setProductType()
     * @uses JP_ZoneListRequest::setShowIATA()
     * @uses JP_ZoneListRequest::setMaxLevel()
     * @param string $productType
     * @param bool $showIATA
     * @param int $maxLevel
     */
    public function __construct($productType = null, $showIATA = null, $maxLevel = null)
    {
        $this
            ->setProductType($productType)
            ->setShowIATA($showIATA)
            ->setMaxLevel($maxLevel);
    }
    /**
     * Get ProductType value
     * @return string|null
     */
    public function getProductType()
    {
        return $this->ProductType;
    }
    /**
     * Set ProductType value
     * @uses \EnumType\JP_ProductType::valueIsValid()
     * @uses \EnumType\JP_ProductType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $productType
     * @return \StructType\JP_ZoneListRequest
     */
    public function setProductType($productType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ProductType::valueIsValid($productType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $productType, implode(', ', \EnumType\JP_ProductType::getValidValues())), __LINE__);
        }
        $this->ProductType = $productType;
        return $this;
    }
    /**
     * Get ShowIATA value
     * @return bool|null
     */
    public function getShowIATA()
    {
        return $this->ShowIATA;
    }
    /**
     * Set ShowIATA value
     * @param bool $showIATA
     * @return \StructType\JP_ZoneListRequest
     */
    public function setShowIATA($showIATA = null)
    {
        // validation for constraint: boolean
        if (!is_null($showIATA) && !is_bool($showIATA)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($showIATA)), __LINE__);
        }
        $this->ShowIATA = $showIATA;
        return $this;
    }
    /**
     * Get MaxLevel value
     * @return int|null
     */
    public function getMaxLevel()
    {
        return $this->MaxLevel;
    }
    /**
     * Set MaxLevel value
     * @param int $maxLevel
     * @return \StructType\JP_ZoneListRequest
     */
    public function setMaxLevel($maxLevel = null)
    {
        // validation for constraint: int
        if (!is_null($maxLevel) && !is_numeric($maxLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($maxLevel)), __LINE__);
        }
        $this->MaxLevel = $maxLevel;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ZoneListRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
