<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_ServiceContentOption ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_ServiceContentOption extends AbstractStructArrayBase
{
    /**
     * The ServiceOption
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ServiceContentOption[]
     */
    public $ServiceOption;
    /**
     * Constructor method for ArrayOfJP_ServiceContentOption
     * @uses ArrayOfJP_ServiceContentOption::setServiceOption()
     * @param \StructType\JP_ServiceContentOption[] $serviceOption
     */
    public function __construct(array $serviceOption = array())
    {
        $this
            ->setServiceOption($serviceOption);
    }
    /**
     * Get ServiceOption value
     * @return \StructType\JP_ServiceContentOption[]|null
     */
    public function getServiceOption()
    {
        return $this->ServiceOption;
    }
    /**
     * Set ServiceOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceContentOption[] $serviceOption
     * @return \ArrayType\ArrayOfJP_ServiceContentOption
     */
    public function setServiceOption(array $serviceOption = array())
    {
        foreach ($serviceOption as $arrayOfJP_ServiceContentOptionServiceOptionItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_ServiceContentOptionServiceOptionItem instanceof \StructType\JP_ServiceContentOption) {
                throw new \InvalidArgumentException(sprintf('The ServiceOption property can only contain items of \StructType\JP_ServiceContentOption, "%s" given', is_object($arrayOfJP_ServiceContentOptionServiceOptionItem) ? get_class($arrayOfJP_ServiceContentOptionServiceOptionItem) : gettype($arrayOfJP_ServiceContentOptionServiceOptionItem)), __LINE__);
            }
        }
        $this->ServiceOption = $serviceOption;
        return $this;
    }
    /**
     * Add item to ServiceOption value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceContentOption $item
     * @return \ArrayType\ArrayOfJP_ServiceContentOption
     */
    public function addToServiceOption(\StructType\JP_ServiceContentOption $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ServiceContentOption) {
            throw new \InvalidArgumentException(sprintf('The ServiceOption property can only contain items of \StructType\JP_ServiceContentOption, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ServiceOption[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_ServiceContentOption|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_ServiceContentOption|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_ServiceContentOption|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_ServiceContentOption|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_ServiceContentOption|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ServiceOption
     */
    public function getAttributeName()
    {
        return 'ServiceOption';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_ServiceContentOption
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
