<?php

namespace EnumType;

/**
 * This class stands for JP_ZoneInfoType EnumType
 * @subpackage Enumerations
 */
class JP_ZoneInfoType
{
    /**
     * Constant for value 'BASE'
     * @return string 'BASE'
     */
    const VALUE_BASE = 'BASE';
    /**
     * Constant for value 'EXTENDEDLANG'
     * @return string 'EXTENDEDLANG'
     */
    const VALUE_EXTENDEDLANG = 'EXTENDEDLANG';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_BASE
     * @uses self::VALUE_EXTENDEDLANG
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_BASE,
            self::VALUE_EXTENDEDLANG,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
