<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArrayOfJP_FlightTicketInfo ArrayType
 * @subpackage Arrays
 */
class ArrayOfArrayOfJP_FlightTicketInfo extends AbstractStructArrayBase
{
    /**
     * The Reservation
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_FlightTicketInfo[]
     */
    public $Reservation;
    /**
     * Constructor method for ArrayOfArrayOfJP_FlightTicketInfo
     * @uses ArrayOfArrayOfJP_FlightTicketInfo::setReservation()
     * @param \ArrayType\ArrayOfJP_FlightTicketInfo[] $reservation
     */
    public function __construct(array $reservation = array())
    {
        $this
            ->setReservation($reservation);
    }
    /**
     * Get Reservation value
     * @return \ArrayType\ArrayOfJP_FlightTicketInfo[]|null
     */
    public function getReservation()
    {
        return $this->Reservation;
    }
    /**
     * Set Reservation value
     * @throws \InvalidArgumentException
     * @param \ArrayType\ArrayOfJP_FlightTicketInfo[] $reservation
     * @return \ArrayType\ArrayOfArrayOfJP_FlightTicketInfo
     */
    public function setReservation(array $reservation = array())
    {
        foreach ($reservation as $arrayOfArrayOfJP_FlightTicketInfoReservationItem) {
            // validation for constraint: itemType
            if (!$arrayOfArrayOfJP_FlightTicketInfoReservationItem instanceof \ArrayType\ArrayOfJP_FlightTicketInfo) {
                throw new \InvalidArgumentException(sprintf('The Reservation property can only contain items of \ArrayType\ArrayOfJP_FlightTicketInfo, "%s" given', is_object($arrayOfArrayOfJP_FlightTicketInfoReservationItem) ? get_class($arrayOfArrayOfJP_FlightTicketInfoReservationItem) : gettype($arrayOfArrayOfJP_FlightTicketInfoReservationItem)), __LINE__);
            }
        }
        $this->Reservation = $reservation;
        return $this;
    }
    /**
     * Add item to Reservation value
     * @throws \InvalidArgumentException
     * @param \ArrayType\ArrayOfJP_FlightTicketInfo $item
     * @return \ArrayType\ArrayOfArrayOfJP_FlightTicketInfo
     */
    public function addToReservation(\ArrayType\ArrayOfJP_FlightTicketInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \ArrayType\ArrayOfJP_FlightTicketInfo) {
            throw new \InvalidArgumentException(sprintf('The Reservation property can only contain items of \ArrayType\ArrayOfJP_FlightTicketInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Reservation[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \ArrayType\ArrayOfJP_FlightTicketInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \ArrayType\ArrayOfJP_FlightTicketInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \ArrayType\ArrayOfJP_FlightTicketInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \ArrayType\ArrayOfJP_FlightTicketInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \ArrayType\ArrayOfJP_FlightTicketInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Reservation
     */
    public function getAttributeName()
    {
        return 'Reservation';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfArrayOfJP_FlightTicketInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
