<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Warnings StructType
 * @subpackage Structs
 */
class JP_Warnings extends AbstractStructBase
{
    /**
     * The Warning
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_WarningType[]
     */
    public $Warning;
    /**
     * The CancelInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CancelInformation[]
     */
    public $CancelInfo;
    /**
     * Constructor method for JP_Warnings
     * @uses JP_Warnings::setWarning()
     * @uses JP_Warnings::setCancelInfo()
     * @param \StructType\JP_WarningType[] $warning
     * @param \StructType\JP_CancelInformation[] $cancelInfo
     */
    public function __construct(array $warning = array(), array $cancelInfo = array())
    {
        $this
            ->setWarning($warning)
            ->setCancelInfo($cancelInfo);
    }
    /**
     * Get Warning value
     * @return \StructType\JP_WarningType[]|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * Set Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_WarningType[] $warning
     * @return \StructType\JP_Warnings
     */
    public function setWarning(array $warning = array())
    {
        foreach ($warning as $jP_WarningsWarningItem) {
            // validation for constraint: itemType
            if (!$jP_WarningsWarningItem instanceof \StructType\JP_WarningType) {
                throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of \StructType\JP_WarningType, "%s" given', is_object($jP_WarningsWarningItem) ? get_class($jP_WarningsWarningItem) : gettype($jP_WarningsWarningItem)), __LINE__);
            }
        }
        $this->Warning = $warning;
        return $this;
    }
    /**
     * Add item to Warning value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_WarningType $item
     * @return \StructType\JP_Warnings
     */
    public function addToWarning(\StructType\JP_WarningType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_WarningType) {
            throw new \InvalidArgumentException(sprintf('The Warning property can only contain items of \StructType\JP_WarningType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Warning[] = $item;
        return $this;
    }
    /**
     * Get CancelInfo value
     * @return \StructType\JP_CancelInformation[]|null
     */
    public function getCancelInfo()
    {
        return $this->CancelInfo;
    }
    /**
     * Set CancelInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CancelInformation[] $cancelInfo
     * @return \StructType\JP_Warnings
     */
    public function setCancelInfo(array $cancelInfo = array())
    {
        foreach ($cancelInfo as $jP_WarningsCancelInfoItem) {
            // validation for constraint: itemType
            if (!$jP_WarningsCancelInfoItem instanceof \StructType\JP_CancelInformation) {
                throw new \InvalidArgumentException(sprintf('The CancelInfo property can only contain items of \StructType\JP_CancelInformation, "%s" given', is_object($jP_WarningsCancelInfoItem) ? get_class($jP_WarningsCancelInfoItem) : gettype($jP_WarningsCancelInfoItem)), __LINE__);
            }
        }
        $this->CancelInfo = $cancelInfo;
        return $this;
    }
    /**
     * Add item to CancelInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CancelInformation $item
     * @return \StructType\JP_Warnings
     */
    public function addToCancelInfo(\StructType\JP_CancelInformation $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CancelInformation) {
            throw new \InvalidArgumentException(sprintf('The CancelInfo property can only contain items of \StructType\JP_CancelInformation, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CancelInfo[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Warnings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
