<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_PaymentReservation StructType
 * @subpackage Structs
 */
class JP_PaymentReservation extends AbstractStructBase
{
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $Status;
    /**
     * The PaymentInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_PaymentInfo
     */
    public $PaymentInfo;
    /**
     * The Locator
     * @var string
     */
    public $Locator;
    /**
     * Constructor method for JP_PaymentReservation
     * @uses JP_PaymentReservation::setStatus()
     * @uses JP_PaymentReservation::setPaymentInfo()
     * @uses JP_PaymentReservation::setLocator()
     * @param string $status
     * @param \StructType\JP_PaymentInfo $paymentInfo
     * @param string $locator
     */
    public function __construct($status = null, \StructType\JP_PaymentInfo $paymentInfo = null, $locator = null)
    {
        $this
            ->setStatus($status)
            ->setPaymentInfo($paymentInfo)
            ->setLocator($locator);
    }
    /**
     * Get Status value
     * @return string
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\JP_ResStatus::valueIsValid()
     * @uses \EnumType\JP_ResStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\JP_PaymentReservation
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_ResStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $status, implode(', ', \EnumType\JP_ResStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get PaymentInfo value
     * @return \StructType\JP_PaymentInfo|null
     */
    public function getPaymentInfo()
    {
        return $this->PaymentInfo;
    }
    /**
     * Set PaymentInfo value
     * @param \StructType\JP_PaymentInfo $paymentInfo
     * @return \StructType\JP_PaymentReservation
     */
    public function setPaymentInfo(\StructType\JP_PaymentInfo $paymentInfo = null)
    {
        $this->PaymentInfo = $paymentInfo;
        return $this;
    }
    /**
     * Get Locator value
     * @return string|null
     */
    public function getLocator()
    {
        return $this->Locator;
    }
    /**
     * Set Locator value
     * @param string $locator
     * @return \StructType\JP_PaymentReservation
     */
    public function setLocator($locator = null)
    {
        // validation for constraint: string
        if (!is_null($locator) && !is_string($locator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($locator)), __LINE__);
        }
        $this->Locator = $locator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_PaymentReservation
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
