<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfJP_GenericCatalogueItem ArrayType
 * @subpackage Arrays
 */
class ArrayOfJP_GenericCatalogueItem extends AbstractStructArrayBase
{
    /**
     * The CatalogueItem
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_GenericCatalogueItem[]
     */
    public $CatalogueItem;
    /**
     * Constructor method for ArrayOfJP_GenericCatalogueItem
     * @uses ArrayOfJP_GenericCatalogueItem::setCatalogueItem()
     * @param \StructType\JP_GenericCatalogueItem[] $catalogueItem
     */
    public function __construct(array $catalogueItem = array())
    {
        $this
            ->setCatalogueItem($catalogueItem);
    }
    /**
     * Get CatalogueItem value
     * @return \StructType\JP_GenericCatalogueItem[]|null
     */
    public function getCatalogueItem()
    {
        return $this->CatalogueItem;
    }
    /**
     * Set CatalogueItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_GenericCatalogueItem[] $catalogueItem
     * @return \ArrayType\ArrayOfJP_GenericCatalogueItem
     */
    public function setCatalogueItem(array $catalogueItem = array())
    {
        foreach ($catalogueItem as $arrayOfJP_GenericCatalogueItemCatalogueItemItem) {
            // validation for constraint: itemType
            if (!$arrayOfJP_GenericCatalogueItemCatalogueItemItem instanceof \StructType\JP_GenericCatalogueItem) {
                throw new \InvalidArgumentException(sprintf('The CatalogueItem property can only contain items of \StructType\JP_GenericCatalogueItem, "%s" given', is_object($arrayOfJP_GenericCatalogueItemCatalogueItemItem) ? get_class($arrayOfJP_GenericCatalogueItemCatalogueItemItem) : gettype($arrayOfJP_GenericCatalogueItemCatalogueItemItem)), __LINE__);
            }
        }
        $this->CatalogueItem = $catalogueItem;
        return $this;
    }
    /**
     * Add item to CatalogueItem value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_GenericCatalogueItem $item
     * @return \ArrayType\ArrayOfJP_GenericCatalogueItem
     */
    public function addToCatalogueItem(\StructType\JP_GenericCatalogueItem $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_GenericCatalogueItem) {
            throw new \InvalidArgumentException(sprintf('The CatalogueItem property can only contain items of \StructType\JP_GenericCatalogueItem, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->CatalogueItem[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\JP_GenericCatalogueItem|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\JP_GenericCatalogueItem|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\JP_GenericCatalogueItem|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\JP_GenericCatalogueItem|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\JP_GenericCatalogueItem|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string CatalogueItem
     */
    public function getAttributeName()
    {
        return 'CatalogueItem';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfJP_GenericCatalogueItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
