<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_Departments StructType
 * @subpackage Structs
 */
class JP_Departments extends AbstractStructBase
{
    /**
     * The AllowALL
     * Meta informations extracted from the WSDL
     * - use: required
     * @var bool
     */
    public $AllowALL;
    /**
     * The Department
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_CustomerIDElement[]
     */
    public $Department;
    /**
     * Constructor method for JP_Departments
     * @uses JP_Departments::setAllowALL()
     * @uses JP_Departments::setDepartment()
     * @param bool $allowALL
     * @param \StructType\JP_CustomerIDElement[] $department
     */
    public function __construct($allowALL = null, array $department = array())
    {
        $this
            ->setAllowALL($allowALL)
            ->setDepartment($department);
    }
    /**
     * Get AllowALL value
     * @return bool
     */
    public function getAllowALL()
    {
        return $this->AllowALL;
    }
    /**
     * Set AllowALL value
     * @param bool $allowALL
     * @return \StructType\JP_Departments
     */
    public function setAllowALL($allowALL = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowALL) && !is_bool($allowALL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($allowALL)), __LINE__);
        }
        $this->AllowALL = $allowALL;
        return $this;
    }
    /**
     * Get Department value
     * @return \StructType\JP_CustomerIDElement[]|null
     */
    public function getDepartment()
    {
        return $this->Department;
    }
    /**
     * Set Department value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CustomerIDElement[] $department
     * @return \StructType\JP_Departments
     */
    public function setDepartment(array $department = array())
    {
        foreach ($department as $jP_DepartmentsDepartmentItem) {
            // validation for constraint: itemType
            if (!$jP_DepartmentsDepartmentItem instanceof \StructType\JP_CustomerIDElement) {
                throw new \InvalidArgumentException(sprintf('The Department property can only contain items of \StructType\JP_CustomerIDElement, "%s" given', is_object($jP_DepartmentsDepartmentItem) ? get_class($jP_DepartmentsDepartmentItem) : gettype($jP_DepartmentsDepartmentItem)), __LINE__);
            }
        }
        $this->Department = $department;
        return $this;
    }
    /**
     * Add item to Department value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_CustomerIDElement $item
     * @return \StructType\JP_Departments
     */
    public function addToDepartment(\StructType\JP_CustomerIDElement $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_CustomerIDElement) {
            throw new \InvalidArgumentException(sprintf('The Department property can only contain items of \StructType\JP_CustomerIDElement, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Department[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_Departments
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
