<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_CruiseDataRequest StructType
 * @subpackage Structs
 */
class JP_CruiseDataRequest extends AbstractStructBase
{
    /**
     * The IncludeShipInfo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $IncludeShipInfo;
    /**
     * The SearchSegmentData
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_SearchSegmentShip
     */
    public $SearchSegmentData;
    /**
     * The SelectionCode
     * @var string
     */
    public $SelectionCode;
    /**
     * Constructor method for JP_CruiseDataRequest
     * @uses JP_CruiseDataRequest::setIncludeShipInfo()
     * @uses JP_CruiseDataRequest::setSearchSegmentData()
     * @uses JP_CruiseDataRequest::setSelectionCode()
     * @param bool $includeShipInfo
     * @param \StructType\JP_SearchSegmentShip $searchSegmentData
     * @param string $selectionCode
     */
    public function __construct($includeShipInfo = null, \StructType\JP_SearchSegmentShip $searchSegmentData = null, $selectionCode = null)
    {
        $this
            ->setIncludeShipInfo($includeShipInfo)
            ->setSearchSegmentData($searchSegmentData)
            ->setSelectionCode($selectionCode);
    }
    /**
     * Get IncludeShipInfo value
     * @return bool
     */
    public function getIncludeShipInfo()
    {
        return $this->IncludeShipInfo;
    }
    /**
     * Set IncludeShipInfo value
     * @param bool $includeShipInfo
     * @return \StructType\JP_CruiseDataRequest
     */
    public function setIncludeShipInfo($includeShipInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeShipInfo) && !is_bool($includeShipInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($includeShipInfo)), __LINE__);
        }
        $this->IncludeShipInfo = $includeShipInfo;
        return $this;
    }
    /**
     * Get SearchSegmentData value
     * @return \StructType\JP_SearchSegmentShip|null
     */
    public function getSearchSegmentData()
    {
        return $this->SearchSegmentData;
    }
    /**
     * Set SearchSegmentData value
     * @param \StructType\JP_SearchSegmentShip $searchSegmentData
     * @return \StructType\JP_CruiseDataRequest
     */
    public function setSearchSegmentData(\StructType\JP_SearchSegmentShip $searchSegmentData = null)
    {
        $this->SearchSegmentData = $searchSegmentData;
        return $this;
    }
    /**
     * Get SelectionCode value
     * @return string|null
     */
    public function getSelectionCode()
    {
        return $this->SelectionCode;
    }
    /**
     * Set SelectionCode value
     * @param string $selectionCode
     * @return \StructType\JP_CruiseDataRequest
     */
    public function setSelectionCode($selectionCode = null)
    {
        // validation for constraint: string
        if (!is_null($selectionCode) && !is_string($selectionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selectionCode)), __LINE__);
        }
        $this->SelectionCode = $selectionCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_CruiseDataRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
