<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_OperationTime StructType
 * @subpackage Structs
 */
class JP_OperationTime extends AbstractStructBase
{
    /**
     * The Hours
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfJP_Hour
     */
    public $Hours;
    /**
     * The Day
     * @var string
     */
    public $Day;
    /**
     * The DateFrom
     * @var string
     */
    public $DateFrom;
    /**
     * The DateTo
     * @var string
     */
    public $DateTo;
    /**
     * Constructor method for JP_OperationTime
     * @uses JP_OperationTime::setHours()
     * @uses JP_OperationTime::setDay()
     * @uses JP_OperationTime::setDateFrom()
     * @uses JP_OperationTime::setDateTo()
     * @param \ArrayType\ArrayOfJP_Hour $hours
     * @param string $day
     * @param string $dateFrom
     * @param string $dateTo
     */
    public function __construct(\ArrayType\ArrayOfJP_Hour $hours = null, $day = null, $dateFrom = null, $dateTo = null)
    {
        $this
            ->setHours($hours)
            ->setDay($day)
            ->setDateFrom($dateFrom)
            ->setDateTo($dateTo);
    }
    /**
     * Get Hours value
     * @return \ArrayType\ArrayOfJP_Hour|null
     */
    public function getHours()
    {
        return $this->Hours;
    }
    /**
     * Set Hours value
     * @param \ArrayType\ArrayOfJP_Hour $hours
     * @return \StructType\JP_OperationTime
     */
    public function setHours(\ArrayType\ArrayOfJP_Hour $hours = null)
    {
        $this->Hours = $hours;
        return $this;
    }
    /**
     * Get Day value
     * @return string|null
     */
    public function getDay()
    {
        return $this->Day;
    }
    /**
     * Set Day value
     * @param string $day
     * @return \StructType\JP_OperationTime
     */
    public function setDay($day = null)
    {
        // validation for constraint: string
        if (!is_null($day) && !is_string($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($day)), __LINE__);
        }
        $this->Day = $day;
        return $this;
    }
    /**
     * Get DateFrom value
     * @return string|null
     */
    public function getDateFrom()
    {
        return $this->DateFrom;
    }
    /**
     * Set DateFrom value
     * @param string $dateFrom
     * @return \StructType\JP_OperationTime
     */
    public function setDateFrom($dateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($dateFrom) && !is_string($dateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateFrom)), __LINE__);
        }
        $this->DateFrom = $dateFrom;
        return $this;
    }
    /**
     * Get DateTo value
     * @return string|null
     */
    public function getDateTo()
    {
        return $this->DateTo;
    }
    /**
     * Set DateTo value
     * @param string $dateTo
     * @return \StructType\JP_OperationTime
     */
    public function setDateTo($dateTo = null)
    {
        // validation for constraint: string
        if (!is_null($dateTo) && !is_string($dateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateTo)), __LINE__);
        }
        $this->DateTo = $dateTo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_OperationTime
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
