<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentTransfersByHotel StructType
 * @subpackage Structs
 */
class JP_SearchSegmentTransfersByHotel extends JP_SearchSegmentBase
{
    /**
     * The Suppliers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString6
     */
    public $Suppliers;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The Hour
     * @var string
     */
    public $Hour;
    /**
     * The HourEnd
     * @var string
     */
    public $HourEnd;
    /**
     * The Type
     * @var int
     */
    public $Type;
    /**
     * The Route
     * @var string
     */
    public $Route;
    /**
     * Constructor method for JP_SearchSegmentTransfersByHotel
     * @uses JP_SearchSegmentTransfersByHotel::setSuppliers()
     * @uses JP_SearchSegmentTransfersByHotel::setHotelCode()
     * @uses JP_SearchSegmentTransfersByHotel::setHour()
     * @uses JP_SearchSegmentTransfersByHotel::setHourEnd()
     * @uses JP_SearchSegmentTransfersByHotel::setType()
     * @uses JP_SearchSegmentTransfersByHotel::setRoute()
     * @param \ArrayType\ArrayOfString6 $suppliers
     * @param string $hotelCode
     * @param string $hour
     * @param string $hourEnd
     * @param int $type
     * @param string $route
     */
    public function __construct(\ArrayType\ArrayOfString6 $suppliers = null, $hotelCode = null, $hour = null, $hourEnd = null, $type = null, $route = null)
    {
        $this
            ->setSuppliers($suppliers)
            ->setHotelCode($hotelCode)
            ->setHour($hour)
            ->setHourEnd($hourEnd)
            ->setType($type)
            ->setRoute($route);
    }
    /**
     * Get Suppliers value
     * @return \ArrayType\ArrayOfString6|null
     */
    public function getSuppliers()
    {
        return $this->Suppliers;
    }
    /**
     * Set Suppliers value
     * @param \ArrayType\ArrayOfString6 $suppliers
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setSuppliers(\ArrayType\ArrayOfString6 $suppliers = null)
    {
        $this->Suppliers = $suppliers;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get Hour value
     * @return string|null
     */
    public function getHour()
    {
        return $this->Hour;
    }
    /**
     * Set Hour value
     * @param string $hour
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setHour($hour = null)
    {
        // validation for constraint: string
        if (!is_null($hour) && !is_string($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hour)), __LINE__);
        }
        $this->Hour = $hour;
        return $this;
    }
    /**
     * Get HourEnd value
     * @return string|null
     */
    public function getHourEnd()
    {
        return $this->HourEnd;
    }
    /**
     * Set HourEnd value
     * @param string $hourEnd
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setHourEnd($hourEnd = null)
    {
        // validation for constraint: string
        if (!is_null($hourEnd) && !is_string($hourEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hourEnd)), __LINE__);
        }
        $this->HourEnd = $hourEnd;
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Route value
     * @return string|null
     */
    public function getRoute()
    {
        return $this->Route;
    }
    /**
     * Set Route value
     * @uses \EnumType\JP_RouteType::valueIsValid()
     * @uses \EnumType\JP_RouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $route
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public function setRoute($route = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\JP_RouteType::valueIsValid($route)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $route, implode(', ', \EnumType\JP_RouteType::getValidValues())), __LINE__);
        }
        $this->Route = $route;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SearchSegmentTransfersByHotel
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
