<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_FreeNightsOfferQuotation EnumType
 * @subpackage Enumerations
 */
class JPSOAP_FreeNightsOfferQuotation
{
    /**
     * Constant for value 'Cheapest'
     * @return string 'Cheapest'
     */
    const VALUE_CHEAPEST = 'Cheapest';
    /**
     * Constant for value 'MostExpensive'
     * @return string 'MostExpensive'
     */
    const VALUE_MOST_EXPENSIVE = 'MostExpensive';
    /**
     * Constant for value 'FirstNights'
     * @return string 'FirstNights'
     */
    const VALUE_FIRST_NIGHTS = 'FirstNights';
    /**
     * Constant for value 'LastNights'
     * @return string 'LastNights'
     */
    const VALUE_LAST_NIGHTS = 'LastNights';
    /**
     * Constant for value 'CheapestPeriod'
     * @return string 'CheapestPeriod'
     */
    const VALUE_CHEAPEST_PERIOD = 'CheapestPeriod';
    /**
     * Constant for value 'LastPeriodNights'
     * @return string 'LastPeriodNights'
     */
    const VALUE_LAST_PERIOD_NIGHTS = 'LastPeriodNights';
    /**
     * Constant for value 'Average'
     * @return string 'Average'
     */
    const VALUE_AVERAGE = 'Average';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CHEAPEST
     * @uses self::VALUE_MOST_EXPENSIVE
     * @uses self::VALUE_FIRST_NIGHTS
     * @uses self::VALUE_LAST_NIGHTS
     * @uses self::VALUE_CHEAPEST_PERIOD
     * @uses self::VALUE_LAST_PERIOD_NIGHTS
     * @uses self::VALUE_AVERAGE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CHEAPEST,
            self::VALUE_MOST_EXPENSIVE,
            self::VALUE_FIRST_NIGHTS,
            self::VALUE_LAST_NIGHTS,
            self::VALUE_CHEAPEST_PERIOD,
            self::VALUE_LAST_PERIOD_NIGHTS,
            self::VALUE_AVERAGE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
