<?php

namespace EnumType;

/**
 * This class stands for JPSOAP_CancellationPolicyRuleQuotationType EnumType
 * @subpackage Enumerations
 */
class JPSOAP_CancellationPolicyRuleQuotationType
{
    /**
     * Constant for value 'Average'
     * @return string 'Average'
     */
    const VALUE_AVERAGE = 'Average';
    /**
     * Constant for value 'FirstNight'
     * @return string 'FirstNight'
     */
    const VALUE_FIRST_NIGHT = 'FirstNight';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_AVERAGE
     * @uses self::VALUE_FIRST_NIGHT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_AVERAGE,
            self::VALUE_FIRST_NIGHT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
