<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_VisaAvailabilityRQ StructType
 * @subpackage Structs
 */
class JP_VisaAvailabilityRQ extends AbstractStructBase
{
    /**
     * The Login
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Login
     */
    public $Login;
    /**
     * The Paxes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_Paxes
     */
    public $Paxes;
    /**
     * The VisaRequest
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_VisaRequest
     */
    public $VisaRequest;
    /**
     * The AdvancedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_ServicesAvailAdvancedOptions
     */
    public $AdvancedOptions;
    /**
     * The RestrictedOptions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\JP_RestrictedOptions
     */
    public $RestrictedOptions;
    /**
     * The Version
     * @var string
     */
    public $Version;
    /**
     * The Language
     * @var string
     */
    public $Language;
    /**
     * The TimeStamp
     * @var string
     */
    public $TimeStamp;
    /**
     * Constructor method for JP_VisaAvailabilityRQ
     * @uses JP_VisaAvailabilityRQ::setLogin()
     * @uses JP_VisaAvailabilityRQ::setPaxes()
     * @uses JP_VisaAvailabilityRQ::setVisaRequest()
     * @uses JP_VisaAvailabilityRQ::setAdvancedOptions()
     * @uses JP_VisaAvailabilityRQ::setRestrictedOptions()
     * @uses JP_VisaAvailabilityRQ::setVersion()
     * @uses JP_VisaAvailabilityRQ::setLanguage()
     * @uses JP_VisaAvailabilityRQ::setTimeStamp()
     * @param \StructType\JP_Login $login
     * @param \StructType\JP_Paxes $paxes
     * @param \StructType\JP_VisaRequest $visaRequest
     * @param \StructType\JP_ServicesAvailAdvancedOptions $advancedOptions
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @param string $version
     * @param string $language
     * @param string $timeStamp
     */
    public function __construct(\StructType\JP_Login $login = null, \StructType\JP_Paxes $paxes = null, \StructType\JP_VisaRequest $visaRequest = null, \StructType\JP_ServicesAvailAdvancedOptions $advancedOptions = null, \StructType\JP_RestrictedOptions $restrictedOptions = null, $version = null, $language = null, $timeStamp = null)
    {
        $this
            ->setLogin($login)
            ->setPaxes($paxes)
            ->setVisaRequest($visaRequest)
            ->setAdvancedOptions($advancedOptions)
            ->setRestrictedOptions($restrictedOptions)
            ->setVersion($version)
            ->setLanguage($language)
            ->setTimeStamp($timeStamp);
    }
    /**
     * Get Login value
     * @return \StructType\JP_Login|null
     */
    public function getLogin()
    {
        return $this->Login;
    }
    /**
     * Set Login value
     * @param \StructType\JP_Login $login
     * @return \StructType\JP_VisaAvailabilityRQ
     */
    public function setLogin(\StructType\JP_Login $login = null)
    {
        $this->Login = $login;
        return $this;
    }
    /**
     * Get Paxes value
     * @return \StructType\JP_Paxes|null
     */
    public function getPaxes()
    {
        return $this->Paxes;
    }
    /**
     * Set Paxes value
     * @param \StructType\JP_Paxes $paxes
     * @return \StructType\JP_VisaAvailabilityRQ
     */
    public function setPaxes(\StructType\JP_Paxes $paxes = null)
    {
        $this->Paxes = $paxes;
        return $this;
    }
    /**
     * Get VisaRequest value
     * @return \StructType\JP_VisaRequest|null
     */
    public function getVisaRequest()
    {
        return $this->VisaRequest;
    }
    /**
     * Set VisaRequest value
     * @param \StructType\JP_VisaRequest $visaRequest
     * @return \StructType\JP_VisaAvailabilityRQ
     */
    public function setVisaRequest(\StructType\JP_VisaRequest $visaRequest = null)
    {
        $this->VisaRequest = $visaRequest;
        return $this;
    }
    /**
     * Get AdvancedOptions value
     * @return \StructType\JP_ServicesAvailAdvancedOptions|null
     */
    public function getAdvancedOptions()
    {
        return $this->AdvancedOptions;
    }
    /**
     * Set AdvancedOptions value
     * @param \StructType\JP_ServicesAvailAdvancedOptions $advancedOptions
     * @return \StructType\JP_VisaAvailabilityRQ
     */
    public function setAdvancedOptions(\StructType\JP_ServicesAvailAdvancedOptions $advancedOptions = null)
    {
        $this->AdvancedOptions = $advancedOptions;
        return $this;
    }
    /**
     * Get RestrictedOptions value
     * @return \StructType\JP_RestrictedOptions|null
     */
    public function getRestrictedOptions()
    {
        return $this->RestrictedOptions;
    }
    /**
     * Set RestrictedOptions value
     * @param \StructType\JP_RestrictedOptions $restrictedOptions
     * @return \StructType\JP_VisaAvailabilityRQ
     */
    public function setRestrictedOptions(\StructType\JP_RestrictedOptions $restrictedOptions = null)
    {
        $this->RestrictedOptions = $restrictedOptions;
        return $this;
    }
    /**
     * Get Version value
     * @return string|null
     */
    public function getVersion()
    {
        return $this->Version;
    }
    /**
     * Set Version value
     * @param string $version
     * @return \StructType\JP_VisaAvailabilityRQ
     */
    public function setVersion($version = null)
    {
        // validation for constraint: string
        if (!is_null($version) && !is_string($version)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($version)), __LINE__);
        }
        $this->Version = $version;
        return $this;
    }
    /**
     * Get Language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->Language;
    }
    /**
     * Set Language value
     * @param string $language
     * @return \StructType\JP_VisaAvailabilityRQ
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->Language = $language;
        return $this;
    }
    /**
     * Get TimeStamp value
     * @return string|null
     */
    public function getTimeStamp()
    {
        return $this->TimeStamp;
    }
    /**
     * Set TimeStamp value
     * @param string $timeStamp
     * @return \StructType\JP_VisaAvailabilityRQ
     */
    public function setTimeStamp($timeStamp = null)
    {
        // validation for constraint: string
        if (!is_null($timeStamp) && !is_string($timeStamp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timeStamp)), __LINE__);
        }
        $this->TimeStamp = $timeStamp;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_VisaAvailabilityRQ
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
