<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_ServicePortfolio StructType
 * @subpackage Structs
 */
class JP_ServicePortfolio extends AbstractStructBase
{
    /**
     * The Page
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $Page;
    /**
     * The RecordsPerPage
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $RecordsPerPage;
    /**
     * The TotalPages
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalPages;
    /**
     * The TotalRecords
     * Meta informations extracted from the WSDL
     * - use: required
     * @var int
     */
    public $TotalRecords;
    /**
     * The Service
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JP_ServiceSimpleInfo[]
     */
    public $Service;
    /**
     * Constructor method for JP_ServicePortfolio
     * @uses JP_ServicePortfolio::setPage()
     * @uses JP_ServicePortfolio::setRecordsPerPage()
     * @uses JP_ServicePortfolio::setTotalPages()
     * @uses JP_ServicePortfolio::setTotalRecords()
     * @uses JP_ServicePortfolio::setService()
     * @param int $page
     * @param int $recordsPerPage
     * @param int $totalPages
     * @param int $totalRecords
     * @param \StructType\JP_ServiceSimpleInfo[] $service
     */
    public function __construct($page = null, $recordsPerPage = null, $totalPages = null, $totalRecords = null, array $service = array())
    {
        $this
            ->setPage($page)
            ->setRecordsPerPage($recordsPerPage)
            ->setTotalPages($totalPages)
            ->setTotalRecords($totalRecords)
            ->setService($service);
    }
    /**
     * Get Page value
     * @return int
     */
    public function getPage()
    {
        return $this->Page;
    }
    /**
     * Set Page value
     * @param int $page
     * @return \StructType\JP_ServicePortfolio
     */
    public function setPage($page = null)
    {
        // validation for constraint: int
        if (!is_null($page) && !is_numeric($page)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($page)), __LINE__);
        }
        $this->Page = $page;
        return $this;
    }
    /**
     * Get RecordsPerPage value
     * @return int
     */
    public function getRecordsPerPage()
    {
        return $this->RecordsPerPage;
    }
    /**
     * Set RecordsPerPage value
     * @param int $recordsPerPage
     * @return \StructType\JP_ServicePortfolio
     */
    public function setRecordsPerPage($recordsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($recordsPerPage) && !is_numeric($recordsPerPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($recordsPerPage)), __LINE__);
        }
        $this->RecordsPerPage = $recordsPerPage;
        return $this;
    }
    /**
     * Get TotalPages value
     * @return int
     */
    public function getTotalPages()
    {
        return $this->TotalPages;
    }
    /**
     * Set TotalPages value
     * @param int $totalPages
     * @return \StructType\JP_ServicePortfolio
     */
    public function setTotalPages($totalPages = null)
    {
        // validation for constraint: int
        if (!is_null($totalPages) && !is_numeric($totalPages)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalPages)), __LINE__);
        }
        $this->TotalPages = $totalPages;
        return $this;
    }
    /**
     * Get TotalRecords value
     * @return int
     */
    public function getTotalRecords()
    {
        return $this->TotalRecords;
    }
    /**
     * Set TotalRecords value
     * @param int $totalRecords
     * @return \StructType\JP_ServicePortfolio
     */
    public function setTotalRecords($totalRecords = null)
    {
        // validation for constraint: int
        if (!is_null($totalRecords) && !is_numeric($totalRecords)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($totalRecords)), __LINE__);
        }
        $this->TotalRecords = $totalRecords;
        return $this;
    }
    /**
     * Get Service value
     * @return \StructType\JP_ServiceSimpleInfo[]|null
     */
    public function getService()
    {
        return $this->Service;
    }
    /**
     * Set Service value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceSimpleInfo[] $service
     * @return \StructType\JP_ServicePortfolio
     */
    public function setService(array $service = array())
    {
        foreach ($service as $jP_ServicePortfolioServiceItem) {
            // validation for constraint: itemType
            if (!$jP_ServicePortfolioServiceItem instanceof \StructType\JP_ServiceSimpleInfo) {
                throw new \InvalidArgumentException(sprintf('The Service property can only contain items of \StructType\JP_ServiceSimpleInfo, "%s" given', is_object($jP_ServicePortfolioServiceItem) ? get_class($jP_ServicePortfolioServiceItem) : gettype($jP_ServicePortfolioServiceItem)), __LINE__);
            }
        }
        $this->Service = $service;
        return $this;
    }
    /**
     * Add item to Service value
     * @throws \InvalidArgumentException
     * @param \StructType\JP_ServiceSimpleInfo $item
     * @return \StructType\JP_ServicePortfolio
     */
    public function addToService(\StructType\JP_ServiceSimpleInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JP_ServiceSimpleInfo) {
            throw new \InvalidArgumentException(sprintf('The Service property can only contain items of \StructType\JP_ServiceSimpleInfo, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Service[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_ServicePortfolio
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
