<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_SearchSegmentVisa StructType
 * @subpackage Structs
 */
class JP_SearchSegmentVisa extends JP_SearchSegmentBase
{
    /**
     * The Suppliers
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \ArrayType\ArrayOfString6
     */
    public $Suppliers;
    /**
     * The Type
     * @var int
     */
    public $Type;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * The OptionCode
     * @var string
     */
    public $OptionCode;
    /**
     * The InternalSupplier
     * @var int
     */
    public $InternalSupplier;
    /**
     * Constructor method for JP_SearchSegmentVisa
     * @uses JP_SearchSegmentVisa::setSuppliers()
     * @uses JP_SearchSegmentVisa::setType()
     * @uses JP_SearchSegmentVisa::setCode()
     * @uses JP_SearchSegmentVisa::setOptionCode()
     * @uses JP_SearchSegmentVisa::setInternalSupplier()
     * @param \ArrayType\ArrayOfString6 $suppliers
     * @param int $type
     * @param string $code
     * @param string $optionCode
     * @param int $internalSupplier
     */
    public function __construct(\ArrayType\ArrayOfString6 $suppliers = null, $type = null, $code = null, $optionCode = null, $internalSupplier = null)
    {
        $this
            ->setSuppliers($suppliers)
            ->setType($type)
            ->setCode($code)
            ->setOptionCode($optionCode)
            ->setInternalSupplier($internalSupplier);
    }
    /**
     * Get Suppliers value
     * @return \ArrayType\ArrayOfString6|null
     */
    public function getSuppliers()
    {
        return $this->Suppliers;
    }
    /**
     * Set Suppliers value
     * @param \ArrayType\ArrayOfString6 $suppliers
     * @return \StructType\JP_SearchSegmentVisa
     */
    public function setSuppliers(\ArrayType\ArrayOfString6 $suppliers = null)
    {
        $this->Suppliers = $suppliers;
        return $this;
    }
    /**
     * Get Type value
     * @return int|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param int $type
     * @return \StructType\JP_SearchSegmentVisa
     */
    public function setType($type = null)
    {
        // validation for constraint: int
        if (!is_null($type) && !is_numeric($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_SearchSegmentVisa
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get OptionCode value
     * @return string|null
     */
    public function getOptionCode()
    {
        return $this->OptionCode;
    }
    /**
     * Set OptionCode value
     * @param string $optionCode
     * @return \StructType\JP_SearchSegmentVisa
     */
    public function setOptionCode($optionCode = null)
    {
        // validation for constraint: string
        if (!is_null($optionCode) && !is_string($optionCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($optionCode)), __LINE__);
        }
        $this->OptionCode = $optionCode;
        return $this;
    }
    /**
     * Get InternalSupplier value
     * @return int|null
     */
    public function getInternalSupplier()
    {
        return $this->InternalSupplier;
    }
    /**
     * Set InternalSupplier value
     * @param int $internalSupplier
     * @return \StructType\JP_SearchSegmentVisa
     */
    public function setInternalSupplier($internalSupplier = null)
    {
        // validation for constraint: int
        if (!is_null($internalSupplier) && !is_numeric($internalSupplier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($internalSupplier)), __LINE__);
        }
        $this->InternalSupplier = $internalSupplier;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_SearchSegmentVisa
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
