<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_MeetingPointInfo StructType
 * @subpackage Structs
 */
class JP_MeetingPointInfo extends AbstractStructBase
{
    /**
     * The MeetingTime
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $MeetingTime;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The Address
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Address;
    /**
     * The PostalCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PostalCode;
    /**
     * The Code
     * @var string
     */
    public $Code;
    /**
     * Constructor method for JP_MeetingPointInfo
     * @uses JP_MeetingPointInfo::setMeetingTime()
     * @uses JP_MeetingPointInfo::setName()
     * @uses JP_MeetingPointInfo::setAddress()
     * @uses JP_MeetingPointInfo::setPostalCode()
     * @uses JP_MeetingPointInfo::setCode()
     * @param string $meetingTime
     * @param string $name
     * @param string $address
     * @param string $postalCode
     * @param string $code
     */
    public function __construct($meetingTime = null, $name = null, $address = null, $postalCode = null, $code = null)
    {
        $this
            ->setMeetingTime($meetingTime)
            ->setName($name)
            ->setAddress($address)
            ->setPostalCode($postalCode)
            ->setCode($code);
    }
    /**
     * Get MeetingTime value
     * @return string
     */
    public function getMeetingTime()
    {
        return $this->MeetingTime;
    }
    /**
     * Set MeetingTime value
     * @param string $meetingTime
     * @return \StructType\JP_MeetingPointInfo
     */
    public function setMeetingTime($meetingTime = null)
    {
        // validation for constraint: string
        if (!is_null($meetingTime) && !is_string($meetingTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($meetingTime)), __LINE__);
        }
        $this->MeetingTime = $meetingTime;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\JP_MeetingPointInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get Address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->Address;
    }
    /**
     * Set Address value
     * @param string $address
     * @return \StructType\JP_MeetingPointInfo
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->Address = $address;
        return $this;
    }
    /**
     * Get PostalCode value
     * @return string|null
     */
    public function getPostalCode()
    {
        return $this->PostalCode;
    }
    /**
     * Set PostalCode value
     * @param string $postalCode
     * @return \StructType\JP_MeetingPointInfo
     */
    public function setPostalCode($postalCode = null)
    {
        // validation for constraint: string
        if (!is_null($postalCode) && !is_string($postalCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postalCode)), __LINE__);
        }
        $this->PostalCode = $postalCode;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\JP_MeetingPointInfo
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_MeetingPointInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
