<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JP_HotelAllotmentRS StructType
 * @subpackage Structs
 */
class JP_HotelAllotmentRS extends AbstractStructBase
{
    /**
     * The Contract
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\JPSOAP_HotelAvailContract[]
     */
    public $Contract;
    /**
     * The HotelCode
     * @var string
     */
    public $HotelCode;
    /**
     * The HotelCodeEncrypt
     * @var string
     */
    public $HotelCodeEncrypt;
    /**
     * Constructor method for JP_HotelAllotmentRS
     * @uses JP_HotelAllotmentRS::setContract()
     * @uses JP_HotelAllotmentRS::setHotelCode()
     * @uses JP_HotelAllotmentRS::setHotelCodeEncrypt()
     * @param \StructType\JPSOAP_HotelAvailContract[] $contract
     * @param string $hotelCode
     * @param string $hotelCodeEncrypt
     */
    public function __construct(array $contract = array(), $hotelCode = null, $hotelCodeEncrypt = null)
    {
        $this
            ->setContract($contract)
            ->setHotelCode($hotelCode)
            ->setHotelCodeEncrypt($hotelCodeEncrypt);
    }
    /**
     * Get Contract value
     * @return \StructType\JPSOAP_HotelAvailContract[]|null
     */
    public function getContract()
    {
        return $this->Contract;
    }
    /**
     * Set Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_HotelAvailContract[] $contract
     * @return \StructType\JP_HotelAllotmentRS
     */
    public function setContract(array $contract = array())
    {
        foreach ($contract as $jP_HotelAllotmentRSContractItem) {
            // validation for constraint: itemType
            if (!$jP_HotelAllotmentRSContractItem instanceof \StructType\JPSOAP_HotelAvailContract) {
                throw new \InvalidArgumentException(sprintf('The Contract property can only contain items of \StructType\JPSOAP_HotelAvailContract, "%s" given', is_object($jP_HotelAllotmentRSContractItem) ? get_class($jP_HotelAllotmentRSContractItem) : gettype($jP_HotelAllotmentRSContractItem)), __LINE__);
            }
        }
        $this->Contract = $contract;
        return $this;
    }
    /**
     * Add item to Contract value
     * @throws \InvalidArgumentException
     * @param \StructType\JPSOAP_HotelAvailContract $item
     * @return \StructType\JP_HotelAllotmentRS
     */
    public function addToContract(\StructType\JPSOAP_HotelAvailContract $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JPSOAP_HotelAvailContract) {
            throw new \InvalidArgumentException(sprintf('The Contract property can only contain items of \StructType\JPSOAP_HotelAvailContract, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Contract[] = $item;
        return $this;
    }
    /**
     * Get HotelCode value
     * @return string|null
     */
    public function getHotelCode()
    {
        return $this->HotelCode;
    }
    /**
     * Set HotelCode value
     * @param string $hotelCode
     * @return \StructType\JP_HotelAllotmentRS
     */
    public function setHotelCode($hotelCode = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCode) && !is_string($hotelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCode)), __LINE__);
        }
        $this->HotelCode = $hotelCode;
        return $this;
    }
    /**
     * Get HotelCodeEncrypt value
     * @return string|null
     */
    public function getHotelCodeEncrypt()
    {
        return $this->HotelCodeEncrypt;
    }
    /**
     * Set HotelCodeEncrypt value
     * @param string $hotelCodeEncrypt
     * @return \StructType\JP_HotelAllotmentRS
     */
    public function setHotelCodeEncrypt($hotelCodeEncrypt = null)
    {
        // validation for constraint: string
        if (!is_null($hotelCodeEncrypt) && !is_string($hotelCodeEncrypt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hotelCodeEncrypt)), __LINE__);
        }
        $this->HotelCodeEncrypt = $hotelCodeEncrypt;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\JP_HotelAllotmentRS
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
