<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rentacar ServiceType
 * @subpackage Services
 */
class Rentacar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RentacarBooking
     * Meta informations extracted from the WSDL
     * - documentation: book for rentacar.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RentacarBooking $parameters
     * @return \StructType\RentacarBookingResponse|bool
     */
    public function RentacarBooking(\StructType\RentacarBooking $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RentacarBooking($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RentacarAvail
     * Meta informations extracted from the WSDL
     * - documentation: Availability for rentacar.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RentacarAvail $parameters
     * @return \StructType\RentacarAvailResponse|bool
     */
    public function RentacarAvail(\StructType\RentacarAvail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RentacarAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RentacarLocationList
     * Meta informations extracted from the WSDL
     * - documentation: List of rentacar locations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RentacarLocationList $parameters
     * @return \StructType\RentacarLocationListResponse|bool
     */
    public function RentacarLocationList(\StructType\RentacarLocationList $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RentacarLocationList($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RentacarLocationContent
     * Meta informations extracted from the WSDL
     * - documentation: Content Of Rentacar Locations
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RentacarLocationContent $parameters
     * @return \StructType\RentacarLocationContentResponse|bool
     */
    public function RentacarLocationContent(\StructType\RentacarLocationContent $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RentacarLocationContent($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RentacarCheckAvail
     * Meta informations extracted from the WSDL
     * - documentation: CheckAvail for rentacar.
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RentacarCheckAvail $parameters
     * @return \StructType\RentacarCheckAvailResponse|bool
     */
    public function RentacarCheckAvail(\StructType\RentacarCheckAvail $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RentacarCheckAvail($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named RentacarBookingRules
     * Meta informations extracted from the WSDL
     * - documentation: BookingRules Of Rentacar
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RentacarBookingRules $parameters
     * @return \StructType\RentacarBookingRulesResponse|bool
     */
    public function RentacarBookingRules(\StructType\RentacarBookingRules $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->RentacarBookingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RentacarAvailResponse|\StructType\RentacarBookingResponse|\StructType\RentacarBookingRulesResponse|\StructType\RentacarCheckAvailResponse|\StructType\RentacarLocationContentResponse|\StructType\RentacarLocationListResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
